/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.table.renderer;

import edu.umd.coral.model.GradientColorModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class JaccardCellRenderer
extends JLabel
implements TableCellRenderer {
    private Border unselectedBorder = null;
    private Border selectedBorder = null;
    private boolean isBordered = true;
    private int borderThickness = 1;
    private static final long serialVersionUID = 9007553277735237032L;

    public JaccardCellRenderer(boolean isBordered) {
        this.isBordered = isBordered;
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        Float value = (Float)object;
        Color c = GradientColorModel.getLadderColor(value.floatValue(), 1.0f, false);
        this.setBackground(c);
        this.setText(Float.toString(value.floatValue()));
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(this.borderThickness, this.borderThickness, this.borderThickness, this.borderThickness, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        return this;
    }
}

