/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.table;

import edu.umd.coral.model.data.Cooccurrence;
import edu.umd.coral.model.data.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vertex2VertexTableModel
extends AbstractTableModel {
    public static final String ITEM_NAME = "u";
    public static final String ITEM_PAIR_NAME = "v";
    public static final String CO_OCCUR_COUNT = "# co-occur";
    public static final String SIGNATURE = "signature";
    public static final String NET_NEIGHB = "u's neighbors";
    public static final String NET_PAIR_NEIGHB = "v's neighbors";
    public static final String V2V_TABLE = "v2vTable";
    private static final long serialVersionUID = 7020319317613100863L;
    private Cooccurrence[] data;
    private ArrayList<String> columnNames = new ArrayList();
    private boolean compareCustomVertex = false;
    private boolean compareCustomPair = false;
    private Vertex u;
    private Vertex v;

    public Vertex2VertexTableModel() {
        String[] arr;
        String[] stringArray = arr = new String[]{ITEM_NAME, ITEM_PAIR_NAME, CO_OCCUR_COUNT, SIGNATURE};
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.columnNames.add(s);
            ++n2;
        }
    }

    public void setColumns(ArrayList<String> columns) {
        this.columnNames = columns;
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int col) {
        if (this.columnNames != null) {
            return this.columnNames.get(col);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        if (this.data != null) {
            return this.data.length;
        }
        return 0;
    }

    public Cooccurrence getRow(int row) {
        if (this.data == null || row >= this.data.length || row < 0) {
            return null;
        }
        return this.data[row];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || columnIndex < 0 || this.columnNames == null || this.data == null) {
            return null;
        }
        Cooccurrence pair = this.data[rowIndex];
        String column = this.columnNames.get(columnIndex);
        if (column.equals(ITEM_NAME)) {
            return pair.u.getName();
        }
        if (column.equals(ITEM_PAIR_NAME)) {
            return pair.v.getName();
        }
        if (column.equals(CO_OCCUR_COUNT)) {
            return pair.getCooccurrenceCount();
        }
        if (column.equals(SIGNATURE)) {
            return pair;
        }
        if (column.equals(NET_NEIGHB)) {
            return pair.u.getNeighbors();
        }
        if (column.equals(NET_PAIR_NEIGHB)) {
            return pair.v.getNeighbors();
        }
        return null;
    }

    public Comparator<?> getColumnComparator(int columnIndex) {
        String column = this.columnNames.get(columnIndex);
        if (this.compareCustomVertex) {
            this.compareCustomVertex = false;
            return new VertexCustomComparator(this.u);
        }
        if (this.compareCustomPair) {
            this.compareCustomPair = false;
            return new PairCustomComparator(this.u, this.v);
        }
        if (column.equals(ITEM_NAME)) {
            return new StringComparator();
        }
        if (column.equals(ITEM_PAIR_NAME)) {
            return new StringComparator();
        }
        if (column.equals(CO_OCCUR_COUNT)) {
            return new IntComparator();
        }
        if (column.equals(NET_NEIGHB)) {
            return new StringComparator();
        }
        if (column.equals(NET_PAIR_NEIGHB)) {
            return new StringComparator();
        }
        return null;
    }

    public void setData(Map<Vertex, TreeMap<Vertex, Cooccurrence>> vertexPairs) {
        this.data = this.toCooccurrenceArray(vertexPairs);
        HashMap<Integer, Integer> hist = new HashMap<Integer, Integer>();
        Cooccurrence[] cooccurrenceArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            Cooccurrence c = cooccurrenceArray[n2];
            int value = c.getCooccurrenceCount();
            if (hist.containsKey(value)) {
                hist.put(value, (Integer)hist.get(value) + 1);
            } else {
                hist.put(value, 1);
            }
            ++n2;
        }
        System.out.println("Co-cluster : counts");
        Iterator iterator = hist.keySet().iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            System.out.println(String.valueOf(value) + " : " + hist.get(value));
        }
        this.fireTableDataChanged();
    }

    private Cooccurrence[] toCooccurrenceArray(Map<Vertex, TreeMap<Vertex, Cooccurrence>> vertexPairs) {
        if (vertexPairs == null) {
            return null;
        }
        int size = 0;
        for (Map map : vertexPairs.values()) {
            for (Cooccurrence cooccurrence : map.values()) {
                if (cooccurrence.selfReferential()) continue;
                ++size;
            }
        }
        Object[] objectArray = new Cooccurrence[size];
        int i = 0;
        for (Map map : vertexPairs.values()) {
            for (Cooccurrence c : map.values()) {
                if (c.selfReferential()) continue;
                objectArray[i] = c;
                ++i;
            }
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static ArrayList<String> getColumnNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ITEM_NAME);
        list.add(ITEM_PAIR_NAME);
        list.add(CO_OCCUR_COUNT);
        list.add(SIGNATURE);
        list.add(NET_NEIGHB);
        list.add(NET_PAIR_NEIGHB);
        return list;
    }

    public int getColumnIndex(String name) {
        if (this.columnNames != null) {
            return this.columnNames.indexOf(name);
        }
        return -1;
    }

    public ArrayList<String> getSelectedColmnNames() {
        return (ArrayList)this.columnNames.clone();
    }

    public int setSortToTop(Collection<Vertex> col) {
        if (col == null) {
            this.compareCustomPair = false;
            this.compareCustomVertex = false;
            return 0;
        }
        if (col.size() == 2) {
            Iterator<Vertex> iter = col.iterator();
            this.u = iter.next();
            this.v = iter.next();
            return 1;
        }
        return 0;
    }

    public int sortMatchesToTop(Vertex v) {
        return this.sortToTop(this.data, v);
    }

    private int sortToTop(Cooccurrence[] data, Vertex u) {
        final Vertex finalU = u;
        Arrays.sort(data, new Comparator<Cooccurrence>(){

            @Override
            public int compare(Cooccurrence o1, Cooccurrence o2) {
                if (o1.u.equals(finalU)) {
                    return -1;
                }
                if (o2.u.equals(finalU)) {
                    return 1;
                }
                return o1.u.compareTo(o2.u);
            }
        });
        int startIndex = 0;
        boolean notFound = true;
        while (startIndex < data.length && notFound) {
            if (data[startIndex].u.equals(u)) {
                ++startIndex;
                continue;
            }
            notFound = false;
        }
        int endIndex = data.length;
        Cooccurrence[] sublis = new Cooccurrence[endIndex - startIndex + 1];
        int i = startIndex;
        while (i <= endIndex) {
            sublis[i - startIndex] = data[i];
            ++i;
        }
        Arrays.sort(sublis, new Comparator<Cooccurrence>(){

            @Override
            public int compare(Cooccurrence o1, Cooccurrence o2) {
                if (o1.v.equals(finalU)) {
                    return -1;
                }
                if (o2.v.equals(finalU)) {
                    return 1;
                }
                return o1.v.compareTo(o2.v);
            }
        });
        notFound = true;
        while (startIndex < data.length && notFound) {
            if (data[startIndex].v.equals(u)) {
                ++startIndex;
                continue;
            }
            notFound = false;
        }
        return startIndex;
    }

    public int getIndex(Cooccurrence c) {
        if (this.data == null) {
            return -1;
        }
        int index = Arrays.binarySearch(this.data, c);
        return index;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FloatComparator
    implements Comparator<Float> {
        @Override
        public int compare(Float i1, Float i2) {
            if (i1.floatValue() < i2.floatValue()) {
                return -1;
            }
            if (i1.floatValue() > i2.floatValue()) {
                return 1;
            }
            return 0;
        }
    }

    public class IntComparator
    implements Comparator {
        public int compare(Integer i1, Integer i2) {
            if (i1 < i2) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 0;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                int i2;
                int i1 = Integer.parseInt((String)o1);
                if (i1 < (i2 = Integer.parseInt((String)o2))) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }

    public class PairCustomComparator
    implements Comparator {
        private Vertex u;
        private Vertex v;

        public PairCustomComparator(Vertex u, Vertex v) {
            this.u = u;
            this.v = v;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                if (s1.equals(this.u.getName()) && s2.equals(this.v.getName()) || s1.equals(this.v.getName()) && s2.equals(this.u.getName())) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StringComparator
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    }

    public class VertexCustomComparator
    implements Comparator {
        private Vertex v;

        public VertexCustomComparator(Vertex v) {
            this.v = v;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                if (s1.equals(this.v.getName())) {
                    return -1;
                }
                if (s2.equals(this.v.getName())) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
            return 0;
        }
    }
}

