/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.table;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.ModulePair;
import edu.umd.coral.model.data.Score;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.model.metrics.JaccardMetric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteringCompareTableModel
extends AbstractTableModel {
    public static final float SCORE_CUTOFF = 0.3f;
    public static final String ITEM_NAME = "m1";
    public static final String ITEM_PAIR_NAME = "m2";
    public static final String SCORE = "Jaccard";
    public static final String INTERSECTION = "m1 \u2229 m2";
    public static final String INT_SIZE = "|m1 \u2229 m2|";
    public static final String LEFT_DIFF = "m1 \\ m2";
    public static final String LEFT_DIFF_SIZE = "|m1 \\ m2|";
    public static final String RIGHT_DIFF = "m2 \\ m1";
    public static final String RIGHT_DIFF_SIZE = "|m2 \\ m1|";
    public static final String UNION = "m1 \u222a m2";
    public static final String UNION_SIZW = "|m1 \u222a m2|";
    public static final String C2C_TABLE = "c2cTable";
    private float lowerCutoff;
    private float upperCutoff;
    private float lowerModulesizeCutoff = 2.0f;
    private Score<Clustering> selectedPair;
    private ArrayList<ModulePair> data;
    private ArrayList<ModulePair> filteredData;
    private ArrayList<String> columnNames = new ArrayList();
    private static final long serialVersionUID = -1253338653386968636L;

    public ClusteringCompareTableModel() {
        String[] arr;
        String[] stringArray = arr = new String[]{ITEM_NAME, ITEM_PAIR_NAME, SCORE, INTERSECTION, LEFT_DIFF, RIGHT_DIFF};
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.columnNames.add(s);
            ++n2;
        }
    }

    public void setColumns(ArrayList<String> columns) {
        this.columnNames = columns;
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        if (this.columnNames != null) {
            return this.columnNames.size();
        }
        return 0;
    }

    @Override
    public String getColumnName(int col) {
        if (this.columnNames != null) {
            return this.columnNames.get(col);
        }
        return "blah";
    }

    @Override
    public int getRowCount() {
        if (this.filteredData != null) {
            return this.filteredData.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || columnIndex < 0 || this.columnNames == null || this.filteredData == null) {
            return null;
        }
        String column = this.columnNames.get(columnIndex);
        ModulePair pair = this.filteredData.get(rowIndex);
        Object value = null;
        if (column.equals(ITEM_NAME)) {
            value = pair.getM1().getName();
        } else if (column.equals(ITEM_PAIR_NAME)) {
            value = pair.getM2().getName();
        } else if (column.equals(INTERSECTION)) {
            ArrayList<Vertex> collection = pair.getIntersection();
            value = this.collectionToString(collection);
        } else if (column.equals(LEFT_DIFF)) {
            ArrayList<Vertex> collection = pair.getLeftDifference();
            value = this.collectionToString(collection);
        } else if (column.equals(RIGHT_DIFF)) {
            ArrayList<Vertex> collection = pair.getRightDifference();
            value = this.collectionToString(collection);
        } else if (column.equals(SCORE)) {
            value = Float.valueOf(pair.getScore());
        } else if (column.equals(INT_SIZE)) {
            value = pair.getIntersection().size();
        } else if (column.equals(LEFT_DIFF_SIZE)) {
            value = pair.getLeftDifference().size();
        } else if (column.equals(RIGHT_DIFF_SIZE)) {
            value = pair.getRightDifference().size();
        }
        return value;
    }

    private String collectionToString(Collection<Vertex> collection) {
        String str = "";
        for (Vertex v : collection) {
            String name = v.getName();
            str = String.valueOf(str) + name + ",";
        }
        return str;
    }

    private String collectionToTooltipString(Collection<Vertex> collection) {
        String str = "<html>";
        int i = 0;
        int line_length = 0;
        int N = collection.size();
        int MAX_LINE_LEN = 60;
        int MAX_ITEMS = 40;
        if (N == 0) {
            return null;
        }
        for (Vertex v : collection) {
            if (i > 40) {
                str = str.substring(0, str.length() - 2);
                str = String.valueOf(str) + " and " + (N - i) + " more";
                break;
            }
            String name = v.getName();
            if (name.length() + line_length > 60) {
                str = String.valueOf(str) + "<br>" + name + ", ";
                line_length = name.length() + 2;
            } else if (i < N - 1) {
                str = String.valueOf(str) + name + ", ";
                line_length += name.length() + 2;
            } else {
                str = String.valueOf(str) + name;
                line_length += name.length();
            }
            ++i;
        }
        return String.valueOf(str) + "</html>";
    }

    public Comparator<?> getColumnComparator(int columnIndex) {
        String column = this.columnNames.get(columnIndex);
        if (column.equals(ITEM_NAME)) {
            return new StringComparator();
        }
        if (column.equals(ITEM_PAIR_NAME)) {
            return new StringComparator();
        }
        if (column.equals(INT_SIZE)) {
            return new IntComparator();
        }
        if (column.equals(LEFT_DIFF_SIZE)) {
            return new IntComparator();
        }
        if (column.equals(RIGHT_DIFF_SIZE)) {
            return new IntComparator();
        }
        return new StringComparator();
    }

    public float getLowerCutoff() {
        return this.lowerCutoff;
    }

    public void setLowerCutoff(float lowerCutoff) {
        if (lowerCutoff == this.lowerCutoff) {
            return;
        }
        this.lowerCutoff = lowerCutoff;
        this.updateData();
    }

    public float getUpperCutoff() {
        return this.upperCutoff;
    }

    public void setUpperCutoff(float upperCutoff) {
        if (upperCutoff == this.upperCutoff) {
            return;
        }
        this.upperCutoff = upperCutoff;
        this.updateData();
    }

    public Score<Clustering> getScores() {
        return this.selectedPair;
    }

    public void setScore(Score<Clustering> s) {
        this.selectedPair = s;
        if (s == null) {
            this.data = null;
            this.filteredData = null;
            this.fireTableDataChanged();
            return;
        }
        Clustering c1 = (Clustering)s.getXItem();
        Clustering c2 = (Clustering)s.getYItem();
        if (c1 == null || c2 == null) {
            this.data = null;
            this.filteredData = null;
            this.fireTableDataChanged();
            return;
        }
        Collection<Module> modules1 = c1.getModules();
        Collection<Module> modules2 = c2.getModules();
        Iterator<Module> iterator1 = modules1.iterator();
        JaccardMetric metric = new JaccardMetric();
        ArrayList<ModulePair> collection = new ArrayList<ModulePair>();
        while (iterator1.hasNext()) {
            Module module1 = iterator1.next();
            if ((float)module1.getSize() < this.lowerModulesizeCutoff) continue;
            for (Module module2 : modules2) {
                float score;
                if ((float)module2.getSize() < this.lowerModulesizeCutoff || !((score = metric.getScore(module1.getVertices(), module2.getVertices())) >= 0.3f)) continue;
                ModulePair pair = new ModulePair(module1, module2, score);
                collection.add(pair);
            }
        }
        this.data = collection;
        this.filteredData = this.data;
        this.fireTableDataChanged();
    }

    private void updateData() {
        if (this.data == null) {
            return;
        }
        this.filteredData = (ArrayList)this.data.clone();
        for (ModulePair pair : this.data) {
            float score = pair.getScore();
            if (!(score < this.lowerCutoff) && !(score > this.upperCutoff)) continue;
            this.filteredData.remove(pair);
        }
        this.fireTableDataChanged();
    }

    public int getColumnIndex(String name) {
        if (this.columnNames != null) {
            return this.columnNames.indexOf(name);
        }
        return -1;
    }

    public ArrayList<String> getSelectedColumnNames() {
        return (ArrayList)this.columnNames.clone();
    }

    public static ArrayList<String> getColumnNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(ITEM_NAME);
        l.add(ITEM_PAIR_NAME);
        l.add(SCORE);
        l.add(INTERSECTION);
        l.add(INT_SIZE);
        l.add(LEFT_DIFF);
        l.add(LEFT_DIFF_SIZE);
        l.add(RIGHT_DIFF);
        l.add(RIGHT_DIFF_SIZE);
        return l;
    }

    public int getRowIndex(Module m) {
        int i = 0;
        while (i < this.filteredData.size()) {
            ModulePair mp = this.filteredData.get(i);
            if (mp.getM1().equals(m) || mp.getM2().equals(m)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ModulePair getRow(int row) {
        if (row < 0 || this.filteredData == null) {
            return null;
        }
        if (row >= this.filteredData.size()) {
            return null;
        }
        return this.filteredData.get(row);
    }

    public String getToolTipAt(int rowIndex, String column) {
        ModulePair pair = this.filteredData.get(rowIndex);
        String value = null;
        if (column.equals(INTERSECTION)) {
            ArrayList<Vertex> collection = pair.getIntersection();
            value = this.collectionToTooltipString(collection);
        } else if (column.equals(LEFT_DIFF)) {
            ArrayList<Vertex> collection = pair.getLeftDifference();
            value = this.collectionToTooltipString(collection);
        } else if (column.equals(RIGHT_DIFF)) {
            ArrayList<Vertex> collection = pair.getRightDifference();
            value = this.collectionToTooltipString(collection);
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FloatComparator
    implements Comparator<Float> {
        @Override
        public int compare(Float f1, Float f2) {
            if (f1.floatValue() < f2.floatValue()) {
                return -1;
            }
            if (f1.floatValue() > f2.floatValue()) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IntComparator
    implements Comparator<Object> {
        @Override
        public int compare(Integer i1, Integer i2) {
            if (i1 < i2) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                int i2;
                int i1 = Integer.parseInt((String)o1);
                if (i1 < (i2 = Integer.parseInt((String)o2))) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StringComparator
    implements Comparator<String> {
        @Override
        public int compare(String i1, String i2) {
            return i1.compareTo(i2);
        }
    }
}

