/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.panel;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.ui.JPanelExt;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ZoomingPanel
extends JPanelExt
implements ChangeListener,
PropertyChangeListener {
    JSlider slider;
    private static final long serialVersionUID = -450976020731133267L;

    public ZoomingPanel(DataModel model) {
        super(model);
        this.setLayout(new BoxLayout(this, 1));
        TitledBorder leftBorder = BorderFactory.createTitledBorder("Matrix zoom");
        leftBorder.setTitleJustification(1);
        this.setBorder(leftBorder);
        this._dataModel.addPropertyChangeListener("zoomChanged", this);
        this.slider = new JSlider(0, 0, 1000, 100);
        this.slider.setMajorTickSpacing(200);
        this.slider.setMinorTickSpacing(50);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(this);
        this.slider.setAlignmentX(0.0f);
        this.add(this.slider);
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            int zoomValue = source.getValue();
            if (zoomValue > 20) {
                this._dataModel.setZoomValue((float)zoomValue / 100.0f);
            } else {
                this._dataModel.setZoomValue(0.2f);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        this.slider.setValue((int)(this._dataModel.getZoomValue() * 100.0f));
    }
}

