/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.panel;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class ZoomablePanel
extends JPanel
implements MouseWheelListener,
Scrollable,
MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = -747286996950904094L;
    protected float scale = 1.0f;
    protected float translateX = 0.0f;
    protected float translateY = 0.0f;
    protected final float MAX_SCALE = 15.0f;
    protected final float MIN_SCALE = 0.2f;
    protected final float INCR = 0.2f;
    protected int width = 100;
    protected int height = 100;
    protected int maxUnitIncrement = 10;
    protected int pixelsPerVertex = 1;

    public ZoomablePanel() {
        this.setLayout(null);
        this.setMinimumSize(new Dimension(this.width / 2, this.height / 2));
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected Dimension updateMatrixSize() {
        int actualSize;
        int columns = 1000;
        this.width = actualSize = (int)Math.ceil((float)columns * this.scale * (float)this.pixelsPerVertex);
        this.height = actualSize;
        return new Dimension(this.width, this.height);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (g instanceof Graphics2D) {
            if (this.getWidth() == 0 || this.getHeight() == 0) {
                return;
            }
            AffineTransform translateAT = AffineTransform.getTranslateInstance(this.translateX, this.translateY);
            AffineTransform scaleAT = AffineTransform.getScaleInstance(this.scale, this.scale);
            scaleAT.concatenate(translateAT);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent arg0) {
    }

    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 10;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        Dimension size = this.getParent().getSize();
        this.scale = notches > 0 ? (this.scale -= 0.2f) : (this.scale += 0.2f);
        if (this.scale < 0.2f) {
            this.scale = 0.2f;
        } else if (this.scale > 15.0f) {
            this.scale = 15.0f;
        }
        this.updateMatrixSize();
        size = new Dimension(this.width, this.height);
        this.setPreferredSize(size);
        this.revalidate();
    }
}

