/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.panel;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Cooccurrence;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.ui.JPanelExt;
import edu.umd.coral.ui.table.Vertex2VertexTableModel;
import edu.umd.coral.ui.table.Vertex2VertexTableSorter;
import edu.umd.coral.ui.table.renderer.CooccurCellRenderer;
import edu.umd.coral.ui.table.renderer.HistogramCellRenderer;
import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.PatternSyntaxException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vertex2VertexPanel
extends JPanelExt
implements PropertyChangeListener,
ListSelectionListener,
ActionListener,
MouseListener {
    private static final long serialVersionUID = 6715557762733072669L;
    private JTextField sigFilter;
    private JLabel countLabel;
    private Vertex2VertexTableModel tableModel;
    private Vertex2VertexTableSorter sorter;
    private JTable table;

    public Vertex2VertexPanel(DataModel model) {
        super(model);
        model.addPropertyChangeListener("vertexPairsChanged", this);
        model.addPropertyChangeListener("vertexTableColumnsChanged", this);
        model.addPropertyChangeListener("selectedVerticesChanged", this);
        model.addPropertyChangeListener("searchItemChanged", this);
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        JLabel label = new JLabel("Filter:", 11);
        this.sigFilter = new JTextField();
        this.sigFilter.addActionListener(this);
        label.setLabelFor(this.sigFilter);
        this.countLabel = new JLabel();
        this.tableModel = new Vertex2VertexTableModel();
        this.sorter = new Vertex2VertexTableSorter(this.tableModel);
        this.table = new JTable(){
            private static final long serialVersionUID = 7050895341970662607L;

            public TableCellRenderer getCellRenderer(int row, int column) {
                TableModel model = this.getModel();
                if (model instanceof Vertex2VertexTableModel) {
                    Vertex2VertexTableModel v2vm = (Vertex2VertexTableModel)model;
                    int index = v2vm.getColumnIndex("signature");
                    if (index == column) {
                        return new HistogramCellRenderer(true);
                    }
                    index = v2vm.getColumnIndex("# co-occur");
                    Map<String, Clustering> map = Vertex2VertexPanel.this._dataModel.getClusterings();
                    if (map == null) {
                        return null;
                    }
                    int maxValue = map.size();
                    if (index == column) {
                        return new CooccurCellRenderer(true, (float)maxValue);
                    }
                }
                return super.getCellRenderer(row, column);
            }

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int row = this.rowAtPoint(p);
                Cooccurrence c = Vertex2VertexPanel.this.tableModel.getRow(row);
                return c.getNiceHTMLString();
            }
        };
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setModel(this.tableModel);
        this.table.setRowSorter(this.sorter);
        this.table.addMouseListener(this);
        this._dataModel.setVertexTableColumns(this.tableModel.getSelectedColmnNames());
        JScrollPane scroll = new JScrollPane(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(scroll, GroupLayout.Alignment.TRAILING, -1, 376, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sigFilter, -1, 271, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countLabel)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(this.sigFilter, -2, -1, -2).addComponent(this.countLabel)).addComponent(scroll, -1, 275, Short.MAX_VALUE)));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("vertexTableColumnsChanged")) {
            this.tableModel.setColumns(this._dataModel.getVertexTableColumns());
        } else if (name.equals("vertexPairsChanged")) {
            this.tableModel.setData(this._dataModel.getVertexPairs());
            this.countLabel.setText(String.valueOf(this.sorter.getViewRowCount()));
        } else if (name.equals("selectedVerticesChanged")) {
            Map<Vertex, TreeMap<Vertex, Cooccurrence>> pairs = this._dataModel.getVertexPairs();
            if (pairs == null) {
                return;
            }
            ListSelectionModel lsm = this.table.getSelectionModel();
            lsm.clearSelection();
            ArrayList<Vertex> selectedVert = this._dataModel.getSelectedVertices();
            if (selectedVert == null) {
                return;
            }
            lsm.removeListSelectionListener(this);
            if (selectedVert.size() == 2) {
                Vertex v;
                Vertex u = selectedVert.get(0);
                Cooccurrence c = this.getCooccurrence(pairs, u, v = selectedVert.get(1));
                if (c == null) {
                    return;
                }
                int index = this.addToSelection(c);
                Rectangle blah = this.table.getCellRect(index, 0, true);
                this.table.scrollRectToVisible(blah);
            } else if (selectedVert.size() > 2) {
                Cooccurrence c = null;
                int size = selectedVert.size();
                int i = 0;
                while (i < size - 1) {
                    Vertex u = selectedVert.get(i);
                    int j = i + 1;
                    while (j < size) {
                        Vertex v = selectedVert.get(j);
                        c = this.getCooccurrence(pairs, u, v);
                        if (c != null) {
                            this.addToSelection(c);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            this.table.getSelectionModel().addListSelectionListener(this);
        } else if (name.equals("searchItemChanged")) {
            Vertex v = this._dataModel.getSearchItem();
            if (v == null) {
                this.table.getSelectionModel().clearSelection();
            } else {
                int rowCount = this.tableModel.sortMatchesToTop(v);
                this.tableModel.fireTableDataChanged();
                ListSelectionModel selectionModel = this.table.getSelectionModel();
                selectionModel.removeListSelectionListener(this);
                selectionModel.setSelectionInterval(0, rowCount - 1);
                selectionModel.addListSelectionListener(this);
            }
        }
    }

    private int addToSelection(Cooccurrence c) {
        int index = this.tableModel.getIndex(c);
        if (index < 0) {
            return -1;
        }
        if ((index = this.table.convertRowIndexToView(index)) < 0) {
            return -1;
        }
        this.table.getSelectionModel().addSelectionInterval(index, index);
        return index;
    }

    public static void println(String s) {
    }

    private Cooccurrence getCooccurrence(Map<Vertex, TreeMap<Vertex, Cooccurrence>> pairs, Vertex u, Vertex v) {
        Cooccurrence c = null;
        TreeMap<Vertex, Cooccurrence> cooccs = pairs.get(u);
        if (cooccs != null) {
            c = cooccs.get(v);
        }
        cooccs = pairs.get(v);
        if (c == null && cooccs != null) {
            c = cooccs.get(u);
        }
        return c;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return;
        }
        index = this.table.convertRowIndexToModel(index);
        Cooccurrence pair = this.tableModel.getRow(index);
        ArrayList<Vertex> col = new ArrayList<Vertex>();
        col.add(pair.u);
        col.add(pair.v);
        this._dataModel.removePropertyChangeListener("selectedVerticesChanged", this);
        this._dataModel.setSelectedVertices(col);
        this._dataModel.addPropertyChangeListener("selectedVerticesChanged", this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RowFilter<Vertex2VertexTableModel, Object> rf = null;
        try {
            rf = new RowFilter<Vertex2VertexTableModel, Object>(){

                @Override
                public boolean include(RowFilter.Entry<? extends Vertex2VertexTableModel, ? extends Object> entry) {
                    Vertex2VertexTableModel model = entry.getModel();
                    Object o = entry.getIdentifier();
                    if (o instanceof Integer) {
                        int id = (Integer)o;
                        Cooccurrence co = model.getRow(id);
                        String signature = co.getSignature();
                        return signature.matches("^" + Vertex2VertexPanel.this.sigFilter.getText() + "(.)*");
                    }
                    return false;
                }
            };
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        this.sorter.setRowFilter(rf);
        this.countLabel.setText(String.valueOf(this.sorter.getViewRowCount()));
    }

    private void openURL(String value) {
        if (!Desktop.isDesktopSupported()) {
            System.out.println("Desktop is not supported (fatal)");
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            System.out.println("Desktop doesn't support the browse action");
            return;
        }
        try {
            URI uri = new URI("http://www.arabidopsis.org/servlets/TairObject?type=locus&name=" + value);
            desktop.browse(uri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isControlDown()) {
            int c = this.table.getSelectedColumn();
            int r = this.table.getSelectedRow();
            if (r > 0 && c > 0 && r < 2) {
                String value = (String)this.tableModel.getValueAt(r, c);
                this.openURL(value);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

