/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.panel;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.GradientColorModel;
import edu.umd.coral.model.MatrixColorModel;
import edu.umd.coral.model.data.BaseMatrix;
import edu.umd.coral.model.data.Clique;
import edu.umd.coral.model.data.Cooccurrence;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.ui.JPanelExt;
import edu.umd.coral.ui.panel.MatrixPopupMenu;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;
import no.uib.cipr.matrix.MatrixEntry;

public class MatrixVis
extends JPanelExt
implements PropertyChangeListener,
MouseWheelListener,
Scrollable,
MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = -5287455681570860214L;
    private BufferedImage image;
    private BufferedImage lines;
    private BufferedImage cliques;
    private BufferedImage vertSelection;
    private int translateX = 0;
    private int translateY = 0;
    private int width = 10;
    private int height = 10;
    private int actualSize = 0;
    protected Point zoomRegionStart;
    protected Point zoomRegionEnd;
    private final int pixelsPerVertex = 1;
    private int maxUnitIncrement = 1;
    private JPopupMenu popup;
    private int xStartClick;
    private int yStartClick;
    private int xEndClick;
    private int yEndClick;
    private ArrayList<Interval> selectionIndices = new ArrayList();

    public MatrixVis(DataModel model) {
        super(model);
        this.setLayout(new BorderLayout());
        ToolTipManager.sharedInstance().setInitialDelay(0);
        this.requestFocusInWindow(true);
        this.setFocusable(true);
        this.requestFocus();
        this.setMinimumSize(new Dimension(this.width / 2, this.height / 2));
        this.setPreferredSize(new Dimension(this.width, this.height));
        if (model != null) {
            this.setBackground(model.getBackgroundColor());
            model.addPropertyChangeListener("currentMatrixChanged", this);
            model.addPropertyChangeListener("cliquesChanged", this);
            model.addPropertyChangeListener("zoomChanged", this);
            model.addPropertyChangeListener("selectedVerticesChanged", this);
            model.addPropertyChangeListener("highlightCliquesChanged", this);
            model.addPropertyChangeListener("overlayCliques", this);
            model.addPropertyChangeListener("searchItemChanged", this);
        }
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (g instanceof Graphics2D && this.image != null) {
            Graphics2D g2D = (Graphics2D)g;
            float scale = this._dataModel.getZoomValue();
            int destWidth = this.getWidth();
            int destHeight = this.getHeight();
            if (destWidth == 0 || destHeight == 0) {
                return;
            }
            AffineTransform translateAT = AffineTransform.getTranslateInstance(this.translateX, this.translateY);
            AffineTransform scaleAT = AffineTransform.getScaleInstance(scale, scale);
            scaleAT.concatenate(translateAT);
            g2D.drawImage(this.image, scaleAT, null);
            if (this._dataModel.getHighlightCliques() && this.cliques != null) {
                g2D.drawImage(this.cliques, scaleAT, null);
            }
            if ((this.selectionIndices != null || this._dataModel.getSearchItem() != null) && this.lines != null) {
                g2D.drawImage(this.lines, scaleAT, null);
            }
            g2D.drawImage(this.vertSelection, scaleAT, null);
        }
    }

    private void drawVertSelection() {
        if (this.xStartClick < 0 || this.xEndClick < 0 || this.yStartClick < 0 || this.yEndClick < 0) {
            return;
        }
        int width = Math.abs(this.xStartClick - this.xEndClick);
        if (width <= 0) {
            return;
        }
        int minX = Math.min(this.xStartClick, this.xEndClick);
        this.vertSelection = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D imageGraphics = this.vertSelection.createGraphics();
        Color c = new Color(0, 157, 255);
        imageGraphics.setColor(c);
        imageGraphics.setComposite(AlphaComposite.getInstance(3, 0.7f));
        imageGraphics.fillRect(minX, this.yStartClick, width, 1);
    }

    private void flushImage() {
        this.vertSelection = null;
        this.vertSelection = new BufferedImage(this.getWidth(), this.getHeight(), 2);
    }

    private void drawLines() {
        Matrix localMatrix = this._dataModel.getCurrentMatrix();
        if (localMatrix != null && this.selectionIndices != null && this.selectionIndices.size() > 0) {
            int size = localMatrix.getRowCount();
            this.lines = new BufferedImage(size, size, 2);
            Graphics2D g = this.lines.createGraphics();
            g.setColor(Color.CYAN);
            g.setComposite(AlphaComposite.getInstance(3, 0.7f));
            for (Interval inter : this.selectionIndices) {
                int w = inter.xEnd - inter.xStart;
                int h = inter.yEnd - inter.yStart;
                g.fillRect(inter.xStart, 0, w, inter.yStart);
                g.fillRect(inter.xStart, inter.yEnd, w, size - inter.yEnd);
                g.fillRect(0, inter.yStart, inter.xStart, h);
                g.fillRect(inter.xEnd, inter.yStart, size - inter.xEnd, h);
            }
        } else if (this.lines != null) {
            this.lines.flush();
        }
    }

    private void drawCliques() {
        Matrix localMatrix = this._dataModel.getCurrentMatrix();
        if (localMatrix == null) {
            return;
        }
        int size = localMatrix.getRowCount();
        this.cliques = new BufferedImage(size, size, 2);
        Graphics2D cliqueGraphics = this.cliques.createGraphics();
        cliqueGraphics.setBackground(this._dataModel.getBackgroundColor());
        cliqueGraphics.setColor(Color.GREEN);
        cliqueGraphics.setComposite(AlphaComposite.getInstance(3, 0.7f));
        Collection<Clique> cliques = this._dataModel.getCliques();
        if (cliques == null) {
            return;
        }
        int beginCliqInd = -1;
        int in = 0;
        int out = 0;
        for (Clique clique : cliques) {
            beginCliqInd = size + 1;
            int c = clique.size();
            for (Vertex v : clique.getVertices()) {
                int ind = localMatrix.getColumnIndex(v.getName());
                if (ind >= beginCliqInd) continue;
                beginCliqInd = ind;
            }
            cliqueGraphics.setColor(Color.GREEN);
            cliqueGraphics.fillRect(beginCliqInd, beginCliqInd, c, c);
            if (!this._dataModel.hasEdges() || !this._dataModel.getOverlayCliques()) continue;
            in = clique.getInEdges();
            out = clique.getOutEdges();
            if (in == 0 || in + out == 0) continue;
            float side = Math.round(c * in / (in + out));
            if (side == (float)c) {
                side = c - 1;
            }
            if (side == 0.0f) {
                side = 1.0f;
            }
            int delta = Math.round(((float)c - side) / 2.0f);
            cliqueGraphics.setColor(Color.BLUE);
            cliqueGraphics.fillRect(beginCliqInd + delta, beginCliqInd + delta, (int)side, (int)side);
        }
    }

    private void drawMatrix() {
        Matrix localMatrix = this._dataModel.getCurrentMatrix();
        if (localMatrix != null) {
            int rowCount = localMatrix.getRowCount();
            int size = localMatrix.getRowCount();
            this.image = new BufferedImage(size, size, 2);
            Graphics2D imageGraphics = this.image.createGraphics();
            imageGraphics.setBackground(this._dataModel.getBackgroundColor());
            float cutoff = this._dataModel.getLowerBound();
            if (localMatrix instanceof BaseMatrix) {
                BaseMatrix bm = (BaseMatrix)localMatrix;
                Iterator<MatrixEntry> mi = bm.iterator();
                while (mi.hasNext()) {
                    MatrixEntry e = mi.next();
                    double value = e.get();
                    if (value == 0.0) continue;
                    Color c = GradientColorModel.getMatrixColor((float)value, (float)localMatrix.getMax(), false);
                    if (bm.isBase(e.row(), e.column())) {
                        imageGraphics.setColor(c);
                    } else {
                        Color ca = new Color(128, 128, 128);
                        imageGraphics.setColor(ca);
                    }
                    imageGraphics.fillRect(e.row(), e.column(), 1, 1);
                }
            } else {
                float maxValue = (float)localMatrix.getMax();
                int i = 0;
                while (i < rowCount) {
                    int j = 0;
                    while (j < rowCount) {
                        double value = localMatrix.getElement(i, j);
                        if (value != 0.0) {
                            if (value >= (double)cutoff) {
                                imageGraphics.setColor(GradientColorModel.getMatrixColor((float)value, maxValue, false));
                            } else {
                                imageGraphics.setColor(MatrixColorModel.getGrayScaleColor(value, localMatrix.getMax()));
                            }
                            imageGraphics.fillRect(i, j, 1, 1);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        } else {
            this.image = new BufferedImage(1, 1, 2);
            if (this.cliques != null) {
                this.cliques.flush();
            }
        }
    }

    private void updateMatrixSize() {
        Dimension d = this.getParent().getPreferredSize();
        Matrix m = this._dataModel.getCurrentMatrix();
        if (m == null) {
            return;
        }
        int columns = m.getColumnCount();
        float zoomValue = this._dataModel.getZoomValue();
        this.actualSize = (int)Math.ceil((float)columns * zoomValue * 1.0f);
        if (this.actualSize > d.width || this.actualSize > d.height) {
            this.width = this.actualSize;
            this.height = this.actualSize;
        } else {
            this.width = d.width;
            this.height = d.height;
        }
    }

    private void showPopupMenu(MouseEvent e) {
        if (this.popup == null) {
            this.popup = new MatrixPopupMenu(this._dataModel);
        }
        this.popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("zoomChanged")) {
            this.repaint();
        } else if (name.equals("highlightCliquesChanged") || name.equals("overlayCliques")) {
            if (!this._dataModel.getHighlightCliques()) {
                this.cliques = null;
            } else {
                this.drawCliques();
            }
            this.repaint();
        } else if (name.equals("currentMatrixChanged")) {
            this.cliques = null;
            this.lines = null;
            this._dataModel.setHighlightCliques(false);
            this._dataModel.setOverlayCliques(false);
            this.drawMatrix();
            this.repaint();
        } else if (name.equals("searchItemChanged")) {
            Vertex u = this._dataModel.getSearchItem();
            Matrix m = this._dataModel.getCurrentMatrix();
            if (m == null || u == null) {
                this.lines = null;
                this.repaint();
                return;
            }
            int i = m.getColumnIndex(u.getName());
            this.selectionIndices.clear();
            this.selectionIndices.add(new Interval(i, i + 1));
            this.drawLines();
            this.repaint();
        } else if (name.equals("selectedVerticesChanged")) {
            ArrayList<Vertex> collection = this._dataModel.getSelectedVertices();
            Matrix m = this._dataModel.getCurrentMatrix();
            this.selectionIndices.clear();
            if (m == null || collection == null) {
                this.lines = null;
                this.repaint();
                return;
            }
            if (collection.size() == 1) {
                Vertex u = collection.get(0);
                int x = m.getRowIndex(u.getName());
                this.selectionIndices.add(new Interval(x, x + 1));
            } else if (collection.size() == 2) {
                Vertex u = collection.get(0);
                Vertex v = collection.get(1);
                int x = m.getColumnIndex(u.getName());
                int y = m.getRowIndex(v.getName());
                Interval inter = new Interval(x, y, x + 1, y + 1);
                MatrixVis.println("Selecting a new interval: " + inter);
                this.selectionIndices.add(inter);
            } else {
                Interval inter;
                int j;
                int i = 0;
                int[] rows = new int[collection.size()];
                for (Vertex v : collection) {
                    rows[i] = j = m.getRowIndex(v.getName());
                    ++i;
                }
                Arrays.sort(rows);
                i = 0;
                j = 0;
                while (j < rows.length - 1) {
                    if (rows[j] + 1 == rows[j + 1]) {
                        ++j;
                        continue;
                    }
                    inter = new Interval(rows[i], rows[j]);
                    this.selectionIndices.add(inter);
                    j = i = j + 1;
                }
                inter = new Interval(rows[i], rows[j]);
                this.selectionIndices.add(inter);
            }
            this.drawLines();
            this.repaint(5L);
        } else if (!name.equals("boundChanged") && name.equals("cliquesChanged")) {
            this.drawCliques();
            this.repaint(5L);
        }
    }

    public Dimension getPreferredSize() {
        Dimension d = this.getParent().getPreferredSize();
        this.updateMatrixSize();
        if (this.width < d.width && this.height < d.height) {
            return d;
        }
        int w = Math.max(this.width, d.width);
        int h = Math.max(this.height, d.height);
        return new Dimension(w, h);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        float zoomValue = this._dataModel.getZoomValue();
        Dimension size = this.getParent().getSize();
        zoomValue = notches > 0 ? (float)((double)zoomValue - 0.2) : (float)((double)zoomValue + 0.2);
        this.updateMatrixSize();
        this._dataModel.setZoomValue(zoomValue);
        size = new Dimension(this.width, this.height);
        this.setPreferredSize(size);
        this.revalidate();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getParent().getSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle e, int arg1, int arg2) {
        return 10;
    }

    public void mouseDragged(MouseEvent e) {
        int matrixSize;
        this.zoomRegionEnd = e.getPoint();
        float scale = this._dataModel.getZoomValue();
        float matrixX = (float)this.zoomRegionEnd.x / scale;
        float matrixY = (float)this.zoomRegionEnd.y / scale;
        this.xEndClick = (int)Math.floor(matrixX);
        this.yEndClick = (int)Math.floor(matrixY);
        Matrix localMatrix = this._dataModel.getCurrentMatrix();
        if (localMatrix != null && this.xEndClick > (matrixSize = localMatrix.getColumnCount())) {
            this.xEndClick = matrixSize;
        }
        this.drawVertSelection();
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        Matrix localMatrix = this._dataModel.getCurrentMatrix();
        int modifiers = e.getModifiers();
        int rightBtn = modifiers & 4;
        int leftBtn = modifiers & 0x10;
        if (rightBtn == 4) {
            this.showPopupMenu(e);
        } else if (leftBtn == 16) {
            this.requestFocus();
            this.requestFocusInWindow();
            int x = e.getX();
            int y = e.getY();
            float scale = this._dataModel.getZoomValue();
            float matrixX = (float)x / scale;
            float matrixY = (float)y / scale;
            this.selectionIndices.clear();
            if (localMatrix == null) {
                return;
            }
            if (matrixX > (float)localMatrix.getColumnCount() || matrixY > (float)localMatrix.getRowCount()) {
                matrixX = -1.0f;
                matrixY = -1.0f;
                this._dataModel.setSelectedVertices(null);
                return;
            }
            if (matrixX < (float)localMatrix.getColumnCount() && matrixY < (float)localMatrix.getRowCount()) {
                this.selectionIndices.add(new Interval((int)matrixX, (int)matrixY, (int)matrixX + 1, (int)matrixY + 1));
                String nameU = localMatrix.getColumnName((int)matrixX);
                String nameV = localMatrix.getRowName((int)matrixY);
                Map<String, Vertex> map = this._dataModel.getVertices();
                Vertex u = map.get(nameU);
                Vertex v = map.get(nameV);
                ArrayList<Vertex> collection = new ArrayList<Vertex>();
                collection.add(u);
                collection.add(v);
                this.drawLines();
                this.repaint();
                this._dataModel.removePropertyChangeListener("selectedVerticesChanged", this);
                this._dataModel.setSelectedVertices(collection);
                this._dataModel.addPropertyChangeListener("selectedVerticesChanged", this);
            } else {
                this._dataModel.setSelectedVertices(null);
            }
        } else {
            this._dataModel.setSelectedVertices(null);
        }
    }

    public void mouseMoved(MouseEvent e) {
        Matrix m = this._dataModel.getCurrentMatrix();
        int x = e.getX();
        int y = e.getY();
        float scale = this._dataModel.getZoomValue();
        float matrixX = (float)x / scale;
        float matrixY = (float)y / scale;
        if (m == null) {
            return;
        }
        if (matrixX < (float)m.getColumnCount() && matrixY < (float)m.getRowCount()) {
            String nameU = m.getColumnName((int)Math.floor(matrixX));
            String nameV = m.getRowName((int)Math.floor(matrixY));
            Map<Vertex, TreeMap<Vertex, Cooccurrence>> cooccurMap = this._dataModel.getVertexPairs();
            if (cooccurMap != null) {
                Map<String, Vertex> map = this._dataModel.getVertices();
                Vertex u = map.get(nameU);
                Vertex v = map.get(nameV);
                Map cooccurred = cooccurMap.get(u);
                if (cooccurred == null) {
                    this.setToolTipText(String.valueOf(nameU) + "  and  " + nameV + ": " + m.getElement((int)matrixX, (int)matrixY));
                } else {
                    Cooccurrence c = (Cooccurrence)cooccurred.get(v);
                    if (c != null) {
                        this.setToolTipText(c.getNiceHTMLString());
                    } else {
                        this.setToolTipText(null);
                    }
                }
            } else {
                this.setToolTipText(null);
            }
        } else {
            this.setToolTipText(null);
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
        this.requestFocusInWindow();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.requestFocusInWindow();
        this.flushImage();
        this.zoomRegionStart = e.getPoint();
        float scale = this._dataModel.getZoomValue();
        float matrixX = (float)this.zoomRegionStart.x / scale;
        float matrixY = (float)this.zoomRegionStart.y / scale;
        this.xStartClick = (int)Math.floor(matrixX);
        this.yStartClick = (int)Math.floor(matrixY);
        Matrix m = this._dataModel.getCurrentMatrix();
        if (m == null) {
            this.yEndClick = -1;
            this.xEndClick = -1;
            this.yStartClick = -1;
            this.xStartClick = -1;
            return;
        }
        if (matrixX >= (float)m.getColumnCount()) {
            this.xStartClick = m.getColumnCount() - 1;
        }
        if (matrixY >= (float)m.getRowCount()) {
            this.yStartClick = m.getRowCount() - 1;
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.flushImage();
        this.zoomRegionEnd = e.getPoint();
        float scale = this._dataModel.getZoomValue();
        float matrixX = (float)this.zoomRegionEnd.x / scale;
        this.xEndClick = this.yEndClick = (int)Math.floor(matrixX);
        this.selectionIndices.clear();
        Matrix matrix = this._dataModel.getCurrentMatrix();
        if (this.xStartClick < 0 || this.xStartClick >= matrix.getColumnCount()) {
            return;
        }
        if (this.xEndClick < 0) {
            this.xEndClick = 0;
        }
        if (this.xEndClick >= matrix.getColumnCount()) {
            this.xEndClick = matrix.getColumnCount() - 1;
        }
        this.selectionIndices.add(new Interval(this.xStartClick, this.xEndClick));
        this.drawLines();
        this.selectVertices(this.xStartClick, this.xEndClick);
        this.repaint();
    }

    private void selectVertices(int x1, int x2) {
        Matrix localMatrix = this._dataModel.getCurrentMatrix();
        Map<String, Vertex> map = this._dataModel.getVertices();
        ArrayList<Vertex> selected = new ArrayList<Vertex>();
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        if (minX > localMatrix.getColumnCount()) {
            return;
        }
        if (maxX >= localMatrix.getColumnCount()) {
            maxX = localMatrix.getColumnCount() - 1;
        }
        int i = minX;
        while (i < maxX) {
            String vertexName = localMatrix.getRowName(i);
            Vertex v = map.get(vertexName);
            selected.add(v);
            ++i;
        }
        this._dataModel.removePropertyChangeListener("selectedVerticesChanged", this);
        this._dataModel.setSelectedVertices(selected);
        this._dataModel.addPropertyChangeListener("selectedVerticesChanged", this);
    }

    public static void println(String s) {
    }

    public RenderedImage getImage() {
        return this.image;
    }

    private class Interval {
        public int xStart;
        public int yStart;
        public int xEnd;
        public int yEnd;

        public Interval(int x, int y) {
            this.xStart = x;
            this.yStart = x;
            this.xEnd = y;
            this.yEnd = y;
        }

        public Interval(int xStart, int yStart, int xEnd, int yEnd) {
            this.xStart = xStart;
            this.yStart = yStart;
            this.xEnd = xEnd;
            this.yEnd = yEnd;
        }

        public String toString() {
            return "(" + this.xStart + "," + this.yStart + ") - (" + this.xEnd + "," + this.yEnd + ")";
        }
    }
}

