/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.panel;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.ui.JPanelExt;
import edu.umd.coral.ui.control.DiscreteLegend;
import edu.umd.coral.ui.panel.HasSaveableImage;
import edu.umd.coral.ui.panel.MatrixVis;
import edu.umd.coral.ui.table.SearchComboModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

public class MatrixPanel
extends JPanelExt
implements ComponentListener,
PropertyChangeListener,
ActionListener,
HasSaveableImage {
    private static final long serialVersionUID = -7050849554117696495L;
    private MatrixVis matrixVis;
    private DiscreteLegend legend;
    private JLabel selectedLabel;
    private JComboBox searchCombo;
    private JButton searchButton;
    private SearchComboModel comboModel;

    public MatrixPanel(DataModel model) {
        super(model);
        this._dataModel = model;
        model.addPropertyChangeListener("verticesChanged", this);
        model.addPropertyChangeListener("currentMatrixChanged", this);
        model.addPropertyChangeListener("selectedVerticesChanged", this);
        this.setLayout(new BorderLayout());
        this.matrixVis = new MatrixVis(this._dataModel);
        JScrollPane pane = new JScrollPane(this.matrixVis);
        pane.addComponentListener(this);
        this.add((Component)pane, "Center");
        JPanel det = new JPanel();
        det.setLayout(new BoxLayout(det, 1));
        JPanel search = new JPanel();
        search.setLayout(new BoxLayout(search, 0));
        search.setAlignmentX(0.0f);
        search.add(new JLabel("Search:"));
        this.comboModel = new SearchComboModel();
        this.searchCombo = new JComboBox(this.comboModel);
        this.searchCombo.setEditable(true);
        AutoCompleteDecorator.decorate((JComboBox)this.searchCombo);
        search.add(this.searchCombo);
        this.searchButton = new JButton("Go");
        this.searchButton.addActionListener(this);
        search.add(this.searchButton);
        det.add(search);
        JSeparator sep = new JSeparator(0);
        sep.setAlignmentX(0.0f);
        det.add(sep);
        JPanel detailPanel = new JPanel();
        detailPanel.setLayout(new BoxLayout(detailPanel, 0));
        this.legend = new DiscreteLegend(5);
        this.legend.setPreferredSize(new Dimension(150, 10));
        this.legend.setMaximumSize(new Dimension(150, 10));
        this.legend.setAlignmentY(0.5f);
        detailPanel.add(this.legend);
        detailPanel.add(Box.createRigidArea(new Dimension(4, 1)));
        JLabel label = new JLabel("Selected:");
        label.setAlignmentY(0.5f);
        detailPanel.add(label);
        this.selectedLabel = new JLabel();
        detailPanel.add(this.selectedLabel);
        this.selectedLabel.setAlignmentY(0.5f);
        detailPanel.setAlignmentX(0.0f);
        det.add(detailPanel);
        this.add((Component)det, "Last");
        this.addComponentListener(this);
    }

    private void updateLegend(int maxValue) {
        this.legend.setMaxValue(maxValue);
        this.legend.revalidate();
    }

    public void componentHidden(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent arg0) {
    }

    public void componentResized(ComponentEvent arg0) {
        this.matrixVis.revalidate();
        this.matrixVis.repaint();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propName = e.getPropertyName();
        if (propName.equals("currentMatrixChanged")) {
            Matrix m = this._dataModel.getCurrentMatrix();
            if (m != null) {
                this.updateLegend((int)m.getMax());
            }
        } else if (propName.equals("selectedVerticesChanged")) {
            ArrayList<Vertex> verts = this._dataModel.getSelectedVertices();
            if (verts != null) {
                this.selectedLabel.setText(((Object)verts).toString());
                this.selectedLabel.setToolTipText(((Object)verts).toString());
            } else {
                this.selectedLabel.setText("");
                this.selectedLabel.setToolTipText("Nothing selected");
            }
        } else if (propName.equals("verticesChanged")) {
            Map<String, Vertex> map = this._dataModel.getVertices();
            if (map == null) {
                this.comboModel.setData(null);
            } else {
                Collection<Vertex> coll = map.values();
                this.comboModel.setData(coll);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.searchButton) {
            Vertex v = (Vertex)this.searchCombo.getSelectedItem();
            this._dataModel.setSearchItem(v);
        }
    }

    public RenderedImage getImage() {
        return this.matrixVis.getImage();
    }
}

