/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.panel;

import edu.umd.coral.managers.MetricScoreManager;
import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.GradientColorModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.ComparisonScores;
import edu.umd.coral.model.data.Score;
import edu.umd.coral.model.metrics.Metric;
import edu.umd.coral.model.metrics.MetricFactory;
import edu.umd.coral.ui.JPanelExt;
import edu.umd.coral.ui.control.ContinuousLegend;
import edu.umd.coral.ui.ladder.All2AllTable;
import edu.umd.coral.ui.panel.HasSaveableImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LadderPanel
extends JPanelExt
implements ActionListener,
PropertyChangeListener,
HasSaveableImage {
    public static final Metric[] metrics = new Metric[]{MetricFactory.getMetricInstance("Jaccard"), MetricFactory.getMetricInstance("Mirkin"), MetricFactory.getMetricInstance("Rand"), MetricFactory.getMetricInstance("Mutual information"), MetricFactory.getMetricInstance("Variation of information"), MetricFactory.getMetricInstance("Purity"), MetricFactory.getMetricInstance("Inverse purity"), MetricFactory.getMetricInstance("Folkes-Mallows"), MetricFactory.getMetricInstance("F-measure")};
    private static final long serialVersionUID = 2503266504179112103L;
    private JComboBox metricsCombo;
    private All2AllTable ladder;
    private ContinuousLegend legend;

    public LadderPanel(DataModel model) {
        super(model);
        this._dataModel.addPropertyChangeListener("originalMatrixChanged", this);
        this.initUI(model);
    }

    private void initUI(DataModel model) {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel l = new JLabel("Metric:");
        panel.add((Component)l, "Before");
        this.metricsCombo = new JComboBox<Metric>(metrics);
        this.metricsCombo.setToolTipText(metrics[0].getAnnotation());
        this.metricsCombo.setSelectedIndex(0);
        this.metricsCombo.addActionListener(this);
        panel.add((Component)this.metricsCombo, "Center");
        this.add((Component)panel, "First");
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.ladder = new All2AllTable();
        this.ladder.addPropertyChangeListener("cellSelectedChanged", this);
        this.ladder.setAlignmentY(1.0f);
        panel.add(this.ladder);
        this.legend = new ContinuousLegend();
        this.legend.setAlignmentY(1.0f);
        panel.add(this.legend);
        this.add((Component)panel, "Center");
    }

    private void updateLegend(float maxValue) {
        this.legend.setMinColor(GradientColorModel.getLadderColor(0.0f, 1.0f, false));
        this.legend.setMaxColor(GradientColorModel.getLadderColor(0.99f, 1.0f, false));
        this.legend.setMinValue(0.0f);
        this.legend.setMaxValue(maxValue);
        this.legend.revalidate();
    }

    public void actionPerformed(ActionEvent e) {
        Metric selectedMetric = (Metric)this.metricsCombo.getSelectedItem();
        this.metricsCombo.setToolTipText(selectedMetric.getAnnotation());
        System.out.println("switched to " + selectedMetric.toString() + " metric");
        this.updateScores(selectedMetric);
        this._dataModel.setSelectedMetric(selectedMetric);
    }

    private void updateScores(Metric m) {
        MetricScoreManager manager = new MetricScoreManager(this._dataModel.getIncludeGrabBag());
        ComparisonScores<Clustering> scores = manager.computeScores(m, this._dataModel.getClusteringOrdering());
        this._dataModel.addScores(m, scores);
        this.ladder.setComparisonItems(scores);
        this.ladder.repaint();
        if (scores != null) {
            this.updateLegend(scores.getMax());
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("cellSelectedChanged")) {
            Score value = (Score)e.getNewValue();
            this._dataModel.setSelectedClusteringPair(value);
        } else if (name.equals("originalMatrixChanged")) {
            this.updateScores(this._dataModel.getSelectedMetric());
            this.repaint();
        }
    }

    public RenderedImage getImage() {
        BufferedImage image = new BufferedImage(this.ladder.getWidth(), this.ladder.getHeight(), 1);
        this.ladder.paint(image.getGraphics());
        return image;
    }
}

