/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.panel;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.ColoredPair;
import edu.umd.coral.ui.JPanelExt;
import edu.umd.coral.ui.control.SimpleBarChart;
import java.awt.BorderLayout;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarChartPanel
extends JPanelExt
implements PropertyChangeListener {
    private static final long serialVersionUID = -7946476817932958622L;
    public static final String EXPORT_ICON = "resources/image.png";
    private String type;
    private String dtype;
    private SimpleBarChart chart;
    public static final String FLOAT = "float";
    public static final String INT = "int";

    public BarChartPanel(DataModel model, String type, String event, String dtype) {
        super(model);
        this.type = type;
        this.dtype = dtype;
        if (this._dataModel != null) {
            this._dataModel.addPropertyChangeListener(event, this);
        }
        this._dataModel.addPropertyChangeListener("edgesChanged", this);
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.chart = new SimpleBarChart(this.dtype);
        if (this.type.equals("Avg. density")) {
            this.chart.showMessage();
        }
        this.add(this.chart);
    }

    private ArrayList<ColoredPair<String, Float>> createDataset(String value) {
        Map<String, Clustering> map = this._dataModel.getClusterings();
        if (map == null) {
            return null;
        }
        Collection<Clustering> clusterings = map.values();
        ArrayList<Clustering> clustList = new ArrayList<Clustering>();
        clustList.addAll(clusterings);
        Collections.sort(clustList, new Comparator<Clustering>(){

            @Override
            public int compare(Clustering s1, Clustering s2) {
                int i2;
                int i1;
                block4: {
                    try {
                        i1 = Integer.valueOf(s1.getName());
                        i2 = Integer.valueOf(s2.getName());
                        if (i1 >= i2) break block4;
                        return -1;
                    }
                    catch (Exception e) {
                        return s1.compareTo(s2);
                    }
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
        });
        if (this.type.equals("Avg. density") && this._dataModel.getEdges() == null) {
            return null;
        }
        ArrayList<ColoredPair<String, Float>> dataset = new ArrayList<ColoredPair<String, Float>>();
        for (Clustering c : clustList) {
            ColoredPair<String, Float> p = new ColoredPair<String, Float>(c.getName(), c.getValue(value, this._dataModel.getIncludeGrabBag()));
            p.setColor(c.getColor());
            p.setOverlap(c.hasOverlap());
            dataset.add(p);
        }
        return dataset;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        ArrayList<ColoredPair<String, Float>> dp = this.createDataset(this.type);
        this.chart.setDataProvider(dp);
        this.repaint();
    }

    public BufferedImage getImage() {
        BufferedImage img = new BufferedImage(this.chart.getWidth(), this.chart.getHeight(), 1);
        this.chart.paint(img.getGraphics());
        return img;
    }
}

