/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.network.layout;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.visual.AggregateItem;
import prefuse.visual.VisualItem;

public class AggregateDragControl
extends ControlAdapter {
    private VisualItem activeItem;
    protected Point2D down = new Point2D.Double();
    protected Point2D temp = new Point2D.Double();
    protected boolean dragged;

    public void itemEntered(VisualItem item, MouseEvent e) {
        Display d = (Display)e.getSource();
        d.setCursor(Cursor.getPredefinedCursor(12));
        this.activeItem = item;
        if (!(item instanceof AggregateItem)) {
            this.setFixed(item, true);
        }
    }

    public void itemExited(VisualItem item, MouseEvent e) {
        if (this.activeItem == item) {
            this.activeItem = null;
            this.setFixed(item, false);
        }
        Display d = (Display)e.getSource();
        d.setCursor(Cursor.getDefaultCursor());
    }

    public void itemPressed(VisualItem item, MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.dragged = false;
        Display d = (Display)e.getComponent();
        d.getAbsoluteCoordinate((Point2D)e.getPoint(), this.down);
        if (item instanceof AggregateItem) {
            this.setFixed(item, true);
        }
    }

    public void itemReleased(VisualItem item, MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (this.dragged) {
            this.activeItem = null;
            this.setFixed(item, false);
            this.dragged = false;
        }
    }

    public void itemDragged(VisualItem item, MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.dragged = true;
        Display d = (Display)e.getComponent();
        d.getAbsoluteCoordinate((Point2D)e.getPoint(), this.temp);
        double dx = this.temp.getX() - this.down.getX();
        double dy = this.temp.getY() - this.down.getY();
        this.move(item, dx, dy);
        this.down.setLocation(this.temp);
    }

    protected void setFixed(VisualItem item, boolean fixed) {
        if (item instanceof AggregateItem) {
            Iterator items = ((AggregateItem)item).items();
            while (items.hasNext()) {
                this.setFixed((VisualItem)items.next(), fixed);
            }
        }
    }

    protected void move(VisualItem item, double dx, double dy) {
        if (item instanceof AggregateItem) {
            Iterator items = ((AggregateItem)item).items();
            while (items.hasNext()) {
                this.move((VisualItem)items.next(), dx, dy);
            }
        } else {
            double x = item.getX();
            double y = item.getY();
            item.setStartX(x);
            item.setStartY(y);
            item.setX(x + dx);
            item.setY(y + dy);
            item.setEndX(x + dx);
            item.setEndY(y + dy);
        }
    }
}

