/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.network;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.ui.network.layout.LabelLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JPanel;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.controls.Control;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.Predicate;
import prefuse.data.io.GraphMLReader;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.render.ShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.GraphLib;
import prefuse.util.PrefuseLib;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.expression.VisiblePredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetVis
extends Visualization {
    public static final String GRAPH = "graph";
    public static final String NODES = "graph.nodes";
    public static final String EDGES = "graph.edges";
    public static final String AGGR = "aggregates";
    public static final String NODE_DECORATORS = "nodeDeco";
    public static final String AGGR_DECORATORS = "aggrDeco";
    public static final String DRAW = "draw";
    public static final String LAYOUT = "layout";
    public static final String FOCUS = "focus";
    public static final String CLUSTER = "cluster";
    public static final String FILTER = "filter";
    public static final String ADJUST = "adjust";
    private Collection<Vertex> selectedVertexPair;

    public NetVis() {
        this.initVis();
    }

    public void initVis() {
        ShapeRenderer nr = new ShapeRenderer(20);
        LabelRenderer tr = new LabelRenderer("name");
        tr.setRoundedCorner(8, 8);
        DefaultRendererFactory drf = new DefaultRendererFactory((Renderer)nr);
        drf.add((Predicate)new InGroupPredicate(NODE_DECORATORS), (Renderer)tr);
        this.setRendererFactory((RendererFactory)drf);
        Graph graph = new Graph();
        graph.getNodes().addColumn("name", String.class);
        graph.getEdges().addColumn("weight", Float.TYPE);
        Node n1 = graph.addNode();
        n1.setString("name", "a");
        Node n2 = graph.addNode();
        n2.setString("name", "b");
        Node n3 = graph.addNode();
        n3.setString("name", "c");
        Node n4 = graph.addNode();
        n4.setString("name", "d");
        graph.addEdge(n1, n2);
        graph.addEdge(n1, n3);
        graph.addEdge(n1, n4);
        graph.addEdge(n3, n4);
        this.setGraph(graph);
        this.setValue(NODES, null, VisualItem.SHAPE, new Integer(1));
        Schema decoratorSchema = PrefuseLib.getVisualItemSchema();
        decoratorSchema.setDefault(VisualItem.FONT, (Object)FontLib.getFont((String)"Tahoma", (double)14.0));
        decoratorSchema.setDefault(VisualItem.TEXTCOLOR, ColorLib.gray((int)50));
        this.addDecorators(NODE_DECORATORS, NODES, (Predicate)new VisiblePredicate(), decoratorSchema);
        ForceDirectedLayout layout = new ForceDirectedLayout(GRAPH, true);
        ColorAction nStroke = new ColorAction(NODES, VisualItem.STROKECOLOR);
        nStroke.setDefaultColor(ColorLib.gray((int)50));
        ColorAction nFill = new ColorAction(NODES, VisualItem.FILLCOLOR);
        nFill.setDefaultColor(ColorLib.gray((int)255));
        ColorAction fFill = new ColorAction(Visualization.FOCUS_ITEMS, VisualItem.FILLCOLOR);
        fFill.setDefaultColor(ColorLib.gray((int)200));
        ColorAction nEdges = new ColorAction(EDGES, VisualItem.STROKECOLOR);
        nEdges.setDefaultColor(ColorLib.gray((int)50));
        ActionList colors = new ActionList();
        colors.add((Action)nStroke);
        colors.add((Action)nFill);
        colors.add((Action)fFill);
        colors.add((Action)nEdges);
        ActionList draw = new ActionList();
        draw.add((Action)colors);
        ActionList animate = new ActionList(-1L);
        animate.add((Action)layout);
        animate.add((Action)new LabelLayout(NODE_DECORATORS));
        animate.add((Action)new RepaintAction());
        this.putAction(DRAW, (Action)draw);
        this.putAction(LAYOUT, (Action)animate);
        this.putAction(FOCUS, new FocusAction());
        this.runAfter(DRAW, LAYOUT);
        this.run(DRAW);
    }

    public void setGraph(Graph g) {
        this.removeGroup(GRAPH);
        VisualGraph vg = this.addGraph(GRAPH, g);
        this.setValue(EDGES, null, VisualItem.INTERACTIVE, Boolean.FALSE);
        VisualItem f = (VisualItem)vg.getNode(0);
        this.getGroup(Visualization.FOCUS_ITEMS).setTuple((Tuple)f);
        f.setFixed(false);
    }

    public void setClustering(Clustering c) {
        this.run(CLUSTER);
    }

    public void setSelectedVertexPair(Collection<Vertex> pair) {
        this.selectedVertexPair = pair;
        Graph graph = new Graph();
        graph.getNodes().addColumn("name", String.class);
        graph.getEdges().addColumn("weight", Float.TYPE);
        this.setGraph(graph);
        this.run(DRAW);
    }

    public static void main(String[] args) {
        UILib.setPlatformLookAndFeel();
        String datafile = null;
        String label = "label";
        if (args.length > 1) {
            datafile = args[0];
            label = args[1];
        }
        JFrame frame = NetVis.demo(datafile, label);
        frame.setDefaultCloseOperation(3);
    }

    public static JFrame demo(String datafile, String label) {
        Graph g = null;
        if (datafile == null) {
            g = GraphLib.getClique((int)15);
            label = "label";
        } else {
            try {
                g = new GraphMLReader().readGraph(datafile);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        return NetVis.demo(g, label);
    }

    public static JFrame demo(Graph g, String label) {
        NetVis vis = new NetVis();
        JPanel panel = new JPanel();
        Display display = new Display((Visualization)vis);
        display.setSize(700, 700);
        display.pan(350.0, 350.0);
        display.setForeground(Color.GRAY);
        display.setBackground(Color.WHITE);
        display.addControlListener((Control)new FocusControl(1));
        display.addControlListener((Control)new DragControl());
        display.addControlListener((Control)new PanControl());
        display.addControlListener((Control)new ZoomControl());
        display.addControlListener((Control)new WheelZoomControl());
        display.addControlListener((Control)new ZoomToFitControl());
        display.addControlListener((Control)new NeighborHighlightControl());
        display.setForeground(Color.GRAY);
        display.setBackground(Color.WHITE);
        panel.add((Component)display);
        JFrame frame = new JFrame("p r e f u s e  |  g r a p h v i e w");
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                NetVis.this.run(NetVis.LAYOUT);
            }

            public void windowDeactivated(WindowEvent e) {
                NetVis.this.cancel(NetVis.LAYOUT);
            }
        });
        return frame;
    }

    public class FocusAction
    extends Action {
        public void run(double frac) {
            VisualGraph g;
            this.m_vis.getGroup(Visualization.FOCUS_ITEMS).clear();
            if (NetVis.this.selectedVertexPair != null && (g = (VisualGraph)this.m_vis.getGroup(NetVis.GRAPH)) == null) {
                return;
            }
        }
    }
}

