/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.dialog;

import edu.umd.coral.model.data.Clique;
import edu.umd.coral.model.data.Vertex;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveCoresDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -80782277629684058L;
    private JTextField textField;
    private JButton choose;
    private JButton okButton;
    private JButton cancelButton;
    Collection<Clique> cliques;

    public SaveCoresDialog(JFrame frame, Collection<Clique> cliques) {
        super(frame, "Save cores", true);
        this.cliques = cliques;
        JPanel panel = new JPanel(new BorderLayout());
        JPanel onTop = new JPanel(new BorderLayout());
        onTop.add((Component)new JLabel("Save to:"), "Before");
        this.textField = new JTextField(16);
        onTop.add((Component)this.textField, "Center");
        this.choose = new JButton("Choose...");
        this.choose.addActionListener(this);
        onTop.add((Component)this.choose, "After");
        panel.add((Component)onTop, "First");
        onTop = new JPanel();
        onTop.setLayout(new BoxLayout(onTop, 0));
        onTop.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        onTop.add(Box.createHorizontalGlue());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        onTop.add(this.cancelButton);
        this.okButton = new JButton("Save");
        this.okButton.addActionListener(this);
        onTop.add(this.okButton);
        panel.add((Component)onTop, "Last");
        this.getContentPane().add(panel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block9: {
            if (e.getSource() == this.choose) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                int retVal = chooser.showSaveDialog(this.getOwner());
                if (retVal != 0) {
                    return;
                }
                File f = chooser.getSelectedFile();
                String fName = f.getName();
                try {
                    if (fName.trim() == "") {
                        fName = "cores.txt";
                        this.textField.setText(String.valueOf(f.getCanonicalPath()) + File.separator + fName);
                        break block9;
                    }
                    this.textField.setText(f.getCanonicalPath());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else if (e.getSource() == this.okButton) {
                String name = this.textField.getText();
                this.saveCliquesToFile(this.cliques, name);
                this.setVisible(false);
                this.dispose();
            } else if (e.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private void saveCliquesToFile(Collection<Clique> cliques, String name) {
        try {
            File f = new File(name);
            System.out.println("Saving cores to " + f.getCanonicalPath());
            BufferedWriter out = new BufferedWriter(new FileWriter(name));
            if (cliques == null) {
                out.close();
                return;
            }
            for (Clique cq : cliques) {
                if (cq.getVertices().size() <= 1) continue;
                out.write(String.valueOf(cq.getQualityValue()) + "\t" + (float)cq.getInEdges() * 1.0f / (float)cq.getOutEdges() + "\t");
                for (Vertex v : cq.getVertices()) {
                    out.write(String.valueOf(v.getName()) + " ");
                }
                out.write("\n");
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        SaveCoresDialog diag = new SaveCoresDialog(new JFrame(), null);
        diag.pack();
        diag.setVisible(true);
    }
}

