/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.control;

import edu.umd.coral.model.data.ColoredPair;
import edu.umd.coral.model.data.Pair;
import edu.umd.coral.ui.control.StripedImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBarChart
extends JPanel {
    private static final long serialVersionUID = 3188537316247087159L;
    private ArrayList<ColoredPair<String, Float>> dataProvider;
    private Color barColor = Color.GREEN;
    private String dtype = "float";
    private final int LABEL_PADDING = 2;
    private final int BOTTOM_PADDING = 17;
    private final int AXIS_WIDTH = 1;
    private final int TICK_LENGTH = 3;
    private boolean showMsg = false;
    private ArrayList<Boolean> overlap;
    BufferedImage stripesImg;
    int img_width = 20;
    TexturePaint tpaint;

    public SimpleBarChart() {
        this.stripesImg = new BufferedImage(this.img_width, this.img_width, 2);
        Graphics2D imgG = this.stripesImg.createGraphics();
        imgG.setColor(Color.blue);
        imgG.setStroke(new BasicStroke(6.0f));
        imgG.drawLine(0, this.img_width / 2, this.img_width / 2, 0);
        imgG.drawLine(this.img_width / 2, this.img_width, this.img_width, this.img_width / 2);
        this.tpaint = new TexturePaint(this.stripesImg, new Rectangle2D.Float(0.0f, 0.0f, this.img_width, this.img_width));
    }

    public SimpleBarChart(String dtype) {
        this.dtype = dtype;
    }

    public Color getBarColor() {
        return this.barColor;
    }

    public void setBarColor(Color barColor) {
        this.barColor = barColor;
        this.repaint();
    }

    public ArrayList<ColoredPair<String, Float>> getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(ArrayList<ColoredPair<String, Float>> dataProvider) {
        this.dataProvider = dataProvider;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g_) {
        super.paintComponent(g_);
        Graphics2D g = (Graphics2D)g_;
        int w = this.getWidth();
        int h = this.getHeight();
        g.clearRect(0, 0, w, h);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        if (this.dataProvider == null || this.dataProvider.size() == 0) {
            this.drawAxisLabels(g, h, 10.0f);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rectangle2D = fm.getStringBounds("9.00", g);
            int littlW = (int)Math.ceil(rectangle2D.getWidth());
            g.setColor(Color.BLACK);
            g.drawLine(littlW + 2, 0, littlW + 2, h - 17);
            g.drawLine(littlW + 2, h - 17, w, h - 17);
            Dimension d = this.getSize();
            Rectangle2D size = fm.getStringBounds("Load network data to see density", g);
            if (this.showMsg) {
                int x = (int)(d.getWidth() - size.getWidth()) / 2;
                int y = (int)(d.getHeight() - size.getHeight()) / 2;
                g.drawString("Load network data to see density", x, y);
            }
            return;
        }
        float maxValue = 0.0f;
        for (Pair pair : this.dataProvider) {
            if (!(((Float)pair.getValue()).floatValue() > maxValue)) continue;
            maxValue = ((Float)pair.getValue()).floatValue();
        }
        int n = this.drawAxisLabels(g, h, maxValue);
        int maxLabelSize = n + 2;
        g.setColor(Color.BLACK);
        g.drawLine(maxLabelSize + 2, 0, maxLabelSize + 2, h - 17);
        g.drawLine(maxLabelSize + 2, h - 17, w, h - 17);
        this.drawBars(g, w, h, maxValue, this.overlap, maxLabelSize);
    }

    private void drawBars(Graphics2D g, int w, int h, float maxValue, ArrayList<Boolean> overlap, int maxLabelSize) {
        float pxPerCount = (float)(h - 17) / maxValue;
        int spacing = 10;
        int count = this.dataProvider.size();
        int barWidth = (w - maxLabelSize - 2 - 1) / count - 2 * spacing;
        int xOffset = maxLabelSize + 2 + 1 + spacing;
        int yBottom = h - 17;
        if (barWidth <= 0) {
            barWidth = 1;
        }
        Formatter fmt = new Formatter();
        FontMetrics fm = g.getFontMetrics();
        for (ColoredPair<String, Float> pair : this.dataProvider) {
            float v = ((Float)pair.getValue()).floatValue();
            int barHeight = (int)Math.floor(pxPerCount * v);
            if (pair.getOverlap()) {
                g.setPaint(StripedImage.getTexturePaint(pair.getColor()));
            } else {
                g.setColor(pair.getColor());
            }
            g.fillRect(xOffset, yBottom - barHeight, barWidth, barHeight);
            g.setColor(Color.BLACK);
            g.drawRect(xOffset, yBottom - barHeight, barWidth, barHeight);
            fmt = new Formatter();
            if (this.dtype == "float") {
                fmt.format("%.2f", pair.getValue());
            } else if (this.dtype == "int") {
                fmt.format("%d", Math.round(((Float)pair.getValue()).floatValue()));
            }
            String sv = fmt.toString();
            Rectangle2D bounds1 = fm.getStringBounds(sv, g);
            int fontWidth = (int)Math.ceil(bounds1.getWidth());
            int fontHeight = (int)Math.ceil(bounds1.getHeight());
            g.drawString(sv, xOffset + barWidth / 2 - fontWidth / 2, Math.min(yBottom - barHeight + fontHeight, yBottom));
            String s = (String)pair.getKey();
            int letterCount = barWidth / 10;
            if (letterCount < s.length()) {
                s = ((String)pair.getKey()).substring(0, letterCount);
            }
            bounds1 = fm.getStringBounds(s, g);
            fontWidth = (int)Math.ceil(bounds1.getWidth());
            fontHeight = (int)Math.ceil(bounds1.getHeight());
            g.drawString(s, xOffset + barWidth / 2 - fontWidth / 2, h - 2);
            xOffset += 2 * spacing + barWidth;
        }
    }

    private int drawAxisLabels(Graphics g, int h, float maxValue) {
        FontMetrics fm = g.getFontMetrics();
        String f = this.suggestFormat(maxValue);
        Formatter form = new Formatter();
        if (this.dtype == "float") {
            form.format(f, Float.valueOf(0.0f));
        } else {
            form.format(f, 0);
        }
        String v = form.toString();
        Rectangle2D bounds1 = fm.getStringBounds(v, g);
        int zeroWidth = (int)Math.ceil(bounds1.getWidth());
        int fontHeight = (int)Math.ceil(bounds1.getHeight());
        form = new Formatter();
        if (this.dtype == "float") {
            form.format(f, Float.valueOf(maxValue));
        } else {
            form.format(f, (int)maxValue);
        }
        v = form.toString();
        bounds1 = fm.getStringBounds(v, g);
        int maxLabelWidth = (int)Math.ceil(bounds1.getWidth());
        int labelY = h - 17;
        int labelX = maxLabelWidth - zeroWidth;
        float delta = this.estimateAxisStep(fontHeight, maxValue, h - 17 - fontHeight);
        float pxStep = delta / maxValue * (float)h;
        float value = 0.0f;
        g.setColor(Color.BLACK);
        while (labelY > 0) {
            form = new Formatter();
            if (this.dtype == "float") {
                form.format(f, Float.valueOf(value));
            } else {
                form.format(f, (int)value);
            }
            v = form.toString();
            bounds1 = fm.getStringBounds(v, g);
            int valueW = (int)Math.ceil(bounds1.getWidth());
            labelX = maxLabelWidth - valueW;
            g.drawString(v, labelX, labelY);
            g.drawLine(maxLabelWidth + 2, labelY, maxLabelWidth + 2 + 3, labelY);
            value += delta;
            labelY = (int)((float)labelY - pxStep);
        }
        return maxLabelWidth;
    }

    private String suggestFormat(float maxValue) {
        int index;
        if (this.dtype == "int") {
            return "%d";
        }
        DecimalFormat formatter = new DecimalFormat("0.##E0");
        String value = formatter.format(maxValue);
        float exponent = Float.parseFloat(value.substring((index = value.indexOf("E")) + 1));
        if (exponent > 1.0f) {
            return "%" + (int)exponent + ".0f";
        }
        if (maxValue <= 10.0f && maxValue > 1.0f) {
            return "%.1f";
        }
        exponent = -exponent + 1.0f;
        String f = "%." + (int)exponent + "f";
        return f;
    }

    private float estimateAxisStep(int fontHeight, float maxValue, int h) {
        float[] increments = new float[]{10.0f, 5.0f, 4.0f, 2.0f, 1.0f, 0.5f, 0.25f, 0.2f, 0.1f};
        DecimalFormat formatter = new DecimalFormat();
        formatter = new DecimalFormat("0.##E0");
        String value = formatter.format(maxValue);
        int index = value.indexOf("E");
        float exponent = Float.parseFloat(value.substring(index + 1));
        float step = 0.0f;
        float inc = step = (float)Math.pow(10.0, exponent);
        int i = 0;
        i = 0;
        while (i < increments.length) {
            inc = step / increments[i];
            if (maxValue / inc < (float)(h / (2 * fontHeight))) break;
            ++i;
        }
        return inc;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SimpleBarChart.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        JFrame f = new JFrame("Swing Paint Demo");
        f.setDefaultCloseOperation(3);
        SimpleBarChart chart = new SimpleBarChart("float");
        chart.setPreferredSize(new Dimension(300, 400));
        ArrayList<ColoredPair<String, Float>> data = new ArrayList<ColoredPair<String, Float>>();
        data.add(new ColoredPair<String, Float>("A", Float.valueOf(6.0f)));
        data.add(new ColoredPair<String, Float>("B", Float.valueOf(5.0f)));
        data.add(new ColoredPair<String, Float>("C", Float.valueOf(4.0f)));
        data.add(new ColoredPair<String, Float>("D", Float.valueOf(4.0f)));
        chart.setDataProvider(data);
        f.add(chart);
        f.pack();
        f.setVisible(true);
        f.setPreferredSize(new Dimension(300, 400));
    }

    public void showMessage() {
        this.showMsg = true;
    }
}

