/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.control;

import edu.umd.coral.ui.control.LegendItem;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Legend
extends JComponent {
    public static final int DELAY = 5;
    private static final long serialVersionUID = -2439066653684227000L;
    private int gap = 0;
    private LegendItem[] legendItems;
    private Dimension preferredSize = new Dimension();

    public Legend() {
        this.setOpaque(true);
        this.setLayout(new BoxLayout(this, 0));
    }

    public void setLegendItems(LegendItem[] items) {
        if (items == null) {
            this.removeAll();
            this.legendItems = null;
            this.repaint();
            return;
        }
        this.legendItems = items;
        int w = 0;
        int h = 0;
        int x = 0;
        LegendItem[] legendItemArray = this.legendItems;
        int n = this.legendItems.length;
        int n2 = 0;
        while (n2 < n) {
            LegendItem li = legendItemArray[n2];
            Dimension size = li.getPreferredSize();
            li.setBounds(x, 0, size.width, size.height);
            this.add(li);
            x += size.width + this.gap;
            w += size.width + this.gap;
            h = li.getHeight();
            ++n2;
        }
        this.preferredSize.width = w -= this.gap;
        this.preferredSize.height = h;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Legend.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        JFrame f = new JFrame("Swing Paint Demo");
        f.setDefaultCloseOperation(3);
        Legend legend = new Legend();
        LegendItem[] li = new LegendItem[]{new LegendItem(Color.BLACK, "0.0"), new LegendItem(Color.GRAY, "1.0"), new LegendItem(Color.BLUE, "2.0"), new LegendItem(Color.GREEN, "3.0"), new LegendItem(Color.YELLOW, "4.0")};
        legend.setLegendItems(li);
        f.add(legend);
        f.pack();
        f.setVisible(true);
    }
}

