/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.control;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.ui.JPanelExt;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prefuse.util.ui.JRangeSlider;

public class EdgeSlider
extends JPanelExt
implements PropertyChangeListener,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = 4882338193919873652L;
    public static final String SLIDER = "slider";
    public static final String INTERNAL = "internal";
    public static final String EXTERNAL = "external";
    private JRangeSlider slider;
    private JRadioButton internal;
    private JRadioButton external;
    private JLabel rangeLabel;

    public EdgeSlider(DataModel model) {
        super(model);
        model.addPropertyChangeListener("internalChanged", this);
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel("Set Edge Weight Range", 0));
        this.rangeLabel = new JLabel("", 0);
        this.setLabel(this.rangeLabel);
        this.add(this.rangeLabel);
        JPanel sliderPane = new JPanel();
        sliderPane.setLayout(new BoxLayout(sliderPane, 0));
        this.slider = new JRangeSlider(model.getMinWeight(), model.getMaxWeight(), model.getLowWeight(), model.getHighWeight(), 1);
        this.slider.addChangeListener((ChangeListener)this);
        JLabel min = new JLabel(" Min: " + model.getMinWeight() + " ");
        JLabel max = new JLabel(" Max: " + model.getMaxWeight() + " ");
        sliderPane.add(min);
        sliderPane.add((Component)this.slider);
        sliderPane.add(max);
        this.add(sliderPane);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new GridLayout(0, 2));
        ButtonGroup group = new ButtonGroup();
        this.internal = new JRadioButton("Internal");
        group.add(this.internal);
        this.internal.setHorizontalAlignment(0);
        this.internal.setVerticalAlignment(0);
        this.internal.setActionCommand(INTERNAL);
        this.internal.addActionListener(this);
        buttonPane.add(this.internal);
        this.external = new JRadioButton("External");
        group.add(this.external);
        this.external.setSelected(true);
        this.external.setHorizontalAlignment(0);
        this.external.setVerticalAlignment(0);
        this.external.setActionCommand(EXTERNAL);
        this.external.addActionListener(this);
        buttonPane.add(this.external);
        this.add(buttonPane);
    }

    private void setLabel(JLabel l) {
        if (this._dataModel.isInternal()) {
            l.setText(String.valueOf(this._dataModel.getLowWeight()) + " < weights < " + this._dataModel.getHighWeight());
        } else {
            l.setText(" weights < " + this._dataModel.getLowWeight() + " & " + this._dataModel.getHighWeight() + "< weights");
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("boundryWeightChanged")) {
            this.slider.setHighValue(this._dataModel.getHighWeight());
            this.slider.setLowValue(this._dataModel.getLowWeight());
            this.setLabel(this.rangeLabel);
        } else if (name.equals("internalChanged")) {
            if (this._dataModel.isInternal()) {
                this.internal.setSelected(true);
            } else {
                this.external.setSelected(true);
            }
            this.setLabel(this.rangeLabel);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String name = evt.getActionCommand();
        if (name.equals(INTERNAL)) {
            this._dataModel.setInternal(true);
        } else if (name.equals(EXTERNAL)) {
            this._dataModel.setInternal(false);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this._dataModel.setLowWeight(this.slider.getLowValue());
        this._dataModel.setHighWeight(this.slider.getHighValue());
        this.setLabel(this.rangeLabel);
    }
}

