/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.control;

import edu.umd.coral.model.GradientColorModel;
import edu.umd.coral.model.MatrixColorModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Formatter;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ContinuousLegend
extends JComponent {
    private static final long serialVersionUID = -7498972148139318741L;
    private Color minColor = Color.WHITE;
    private Color maxColor = GradientColorModel.getLadderColor(1.0f, 1.0f, false);
    private float minValue = 0.0f;
    private float maxValue = 1.0f;
    private int gradientWidth = 10;
    private boolean isVertical = true;

    public ContinuousLegend() {
        if (this.isVertical) {
            this.setMinimumSize(new Dimension(30, 50));
        } else {
            this.setMinimumSize(new Dimension(50, 30));
        }
    }

    public ContinuousLegend(Color minColor, Color maxColor) {
        this.minColor = minColor;
        this.maxColor = maxColor;
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public void setVertical(boolean isVertical) {
        this.isVertical = isVertical;
        this.repaint();
    }

    public void setMinColor(Color c) {
        this.minColor = c;
        this.repaint();
    }

    public void setMaxColor(Color c) {
        this.maxColor = c;
        this.repaint();
    }

    public void setMinValue(float value) {
        this.minValue = value;
        this.repaint();
    }

    public void setMaxValue(float value) {
        this.maxValue = value;
        this.repaint();
    }

    private String getString(float value) {
        Formatter fmt = new Formatter();
        fmt.format("%.2f", Float.valueOf(value));
        String sv = fmt.toString();
        return sv;
    }

    public Dimension getPreferredSize() {
        Dimension minSize = this.getMinSize(this.getGraphics());
        Dimension parentSize = this.getParent().getSize();
        Dimension d = this.isVertical ? new Dimension((int)minSize.getWidth(), (int)parentSize.getHeight()) : new Dimension((int)parentSize.getWidth(), (int)minSize.getHeight());
        this.setMaximumSize(d);
        return d;
    }

    private Dimension getMinSize(Graphics g) {
        int minH;
        int minW;
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D bounds1 = fm.getStringBounds(this.getString(this.minValue), g);
        Rectangle2D bounds2 = fm.getStringBounds(this.getString(this.maxValue), g);
        if (this.isVertical) {
            minW = (int)Math.ceil(Math.max(bounds1.getWidth(), bounds2.getWidth())) + this.gradientWidth;
            minH = (int)Math.ceil(bounds1.getHeight() + bounds2.getHeight());
        } else {
            minW = (int)Math.ceil(bounds1.getWidth() + bounds2.getWidth()) + 5;
            minH = (int)Math.ceil(Math.max(bounds1.getHeight(), bounds2.getHeight())) - 3 + this.gradientWidth;
        }
        Dimension d = new Dimension(minW, minH);
        this.setMinimumSize(d);
        return d;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Dimension d = this.getSize();
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D bounds1 = fm.getStringBounds(this.getString(this.minValue), g);
        Rectangle2D bounds2 = fm.getStringBounds(this.getString(this.maxValue), g);
        if (this.isVertical) {
            int labelW = (int)Math.ceil(Math.max(bounds1.getWidth(), bounds2.getWidth()));
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.minColor, 0.0f, d.height, this.maxColor, false);
            g2d.setPaint(paint);
            g2d.fillRect(labelW, 0, this.gradientWidth, d.height);
            g2d.setColor(Color.BLACK);
            Rectangle2D bounds = fm.getStringBounds(this.getString(this.minValue), g2d);
            g2d.drawString(this.getString(this.minValue), 0, (int)Math.ceil(bounds.getHeight()) - 3);
            bounds = fm.getStringBounds(this.getString(this.maxValue), g2d);
            g2d.drawString(this.getString(this.maxValue), 0, d.height - 2);
        } else {
            int labelW = (int)Math.ceil(bounds1.getWidth() + bounds2.getWidth()) + 5;
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.minColor, d.width, 0.0f, this.maxColor, false);
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, d.width, this.gradientWidth);
            g2d.setColor(Color.BLACK);
            g2d.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds(this.getString(this.minValue), g2d);
            g2d.drawString(this.getString(this.minValue), 0, this.gradientWidth + (int)Math.ceil(bounds.getHeight()) - 3);
            bounds = fm.getStringBounds(this.getString(this.minValue), g2d);
            g2d.drawString(this.getString(this.maxValue), d.width - (int)Math.ceil(bounds.getWidth()), this.gradientWidth + (int)Math.ceil(bounds.getHeight()) - 3);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ContinuousLegend.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        JFrame f = new JFrame("Swing Gradient Demo");
        f.setDefaultCloseOperation(3);
        Color c1 = MatrixColorModel.getRGBColor(1.0, 10.0, false);
        Color c2 = MatrixColorModel.getRGBColor(10.0, 10.0, false);
        ContinuousLegend panel = new ContinuousLegend(c1, c2);
        f.setPreferredSize(new Dimension(200, 200));
        f.getContentPane().add(panel);
        f.pack();
        f.setVisible(true);
    }
}

