/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui;

import edu.umd.coral.managers.ClusteringsManager;
import edu.umd.coral.managers.FileParserProgressDialog;
import edu.umd.coral.managers.LooseCliqueFinder;
import edu.umd.coral.managers.MatrixCollapseManager;
import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.BaseMatrix;
import edu.umd.coral.model.data.BitSymmetricMatrix;
import edu.umd.coral.model.data.Clique;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.MyMTJMatrix;
import edu.umd.coral.model.parse.EdgeFileParser;
import edu.umd.coral.ui.dialog.AboutDialog;
import edu.umd.coral.ui.dialog.ReorderMatrixDialog;
import edu.umd.coral.ui.dialog.SaveCoresDialog;
import edu.umd.coral.ui.dialog.SaveMatrixDialog;
import edu.umd.coral.ui.dialog.SelectClusteringOrderDialog;
import edu.umd.coral.ui.dialog.SelectColumnsDialog;
import edu.umd.coral.ui.table.ClusteringCompareTableModel;
import edu.umd.coral.ui.table.Vertex2VertexTableModel;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.View;
import net.infonode.docking.util.DockingUtil;
import no.uib.cipr.matrix.MatrixEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoralMenu
extends JMenuBar
implements ActionListener,
PropertyChangeListener,
DockingWindowListener {
    public static final String CORAL_URL = "http://cbcb.umd.edu/kingsford-group/coral/";
    private static final String ABOUT = "About Coral";
    private static final String GO_TO_WEBPAGE = "Go to Coral webpage";
    private static final String CHOOSE_BASE = "Base";
    private static final String REORDER = "Reorder...";
    private static final String OVERLAY_EDGE_COUNTS = "Overlay edge counts";
    private static final String HIGHLIGHT_CORES = "Highlight cores";
    private static final String SEARCH = "Search...";
    private static final String SHOW_ITEM_LABELS = "Show item labels";
    private static final String SHOW_PARTITION_LABELS = "Show partition labels";
    private static final String ORDER = "Order...";
    private static final String SELECT_MODULE_TABLE_COLUMNS = "Select columns for modules";
    private static final String SELECT_VERTEX_TABLE_COLUMNS = "Select columns for pairs";
    private static final String RESET_WINDOWS = "Reset windows";
    private static final String SAVE_FIGURE = "Save figure...";
    private static final String SAVE_CORES = "Save cores...";
    private static final String SAVE_MATRIX = "Save matrix...";
    private DataModel _dataModel;
    private RootWindow rootWindow;
    private JMenuItem[] viewItems;
    private static final long serialVersionUID = 3003740848858645782L;
    public static final String RESET_WINDOWS_EVENT = null;
    private JCheckBoxMenuItem highlightItem;
    private JCheckBoxMenuItem overlayItem;
    private JMenu baseMenu;

    public CoralMenu(DataModel model, RootWindow rootW) {
        this._dataModel = model;
        this.rootWindow = rootW;
        model.addPropertyChangeListener("clusteringsChanged", this);
        model.addPropertyChangeListener("edgesChanged", this);
        this._dataModel.addPropertyChangeListener("highlightCliquesChanged", this);
        this._dataModel.addPropertyChangeListener("overlayCliques", this);
        this.setUpMenu();
    }

    private void setUpMenu() {
        this.createFileMenu();
        this.createMatrixMenu();
        this.createViewMenu();
        this.createHelpMenu();
        if (this._dataModel.isDebug()) {
            this.createTestMenu();
        }
    }

    private void createTestMenu() {
        JMenu menu = new JMenu("Test");
        menu.setMnemonic(84);
        menu.getAccessibleContext().setAccessibleDescription("Test");
        this.add(menu);
        menu.add(this.getMenuItem("clusterings 6", 76, 2, "Open a saved session"));
        menu.add(this.getMenuItem("karate", 75, 2, "Load karate data"));
        menu.add(this.getMenuItem("arabidopsis", 65, 2, "Load arabidopsis data"));
        menu.add(this.getMenuItem("dave", 68, 2, "Open a file containing network information"));
        menu.add(this.getMenuItem("spawn (3s)", 66, 2, "Spawn a test thread"));
    }

    private void createFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.getAccessibleContext().setAccessibleDescription("File menu");
        this.add(fileMenu);
        fileMenu.add(this.getMenuItem("Open clusterings...", 79, 2, "Open file containing information on clusterings"));
        fileMenu.add(this.getMenuItem("Open network...", 78, 2, "Open a file containing network information"));
        fileMenu.addSeparator();
        JMenu export = new JMenu("Export");
        export.add(this.getMenuItem(SAVE_MATRIX, "Save matrix to a file"));
        export.add(this.getMenuItem(SAVE_CORES, "Save cores to a file"));
        fileMenu.add(export);
        fileMenu.addSeparator();
        fileMenu.add(this.getMenuItem("Quit", 81, 2, "Close the application"));
    }

    private void createViewMenu() {
        JMenu menu = new JMenu("View");
        menu.setMnemonic(86);
        menu.getAccessibleContext().setAccessibleDescription("View options");
        JMenu show = new JMenu("Show");
        View[] views = this._dataModel.getViews();
        this.viewItems = new JMenuItem[views.length];
        int i = 0;
        while (i < views.length) {
            final View v = views[i];
            this.viewItems[i] = new JMenuItem(v.getTitle());
            this.viewItems[i].setEnabled(v.getRootWindow() == null);
            this.viewItems[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (v.getRootWindow() != null) {
                        v.restoreFocus();
                    } else {
                        DockingUtil.addWindow((DockingWindow)v, (RootWindow)CoralMenu.this.rootWindow);
                    }
                }
            });
            show.add(this.viewItems[i]);
            ++i;
        }
        show.addSeparator();
        show.add(this.getMenuItem(RESET_WINDOWS, RESET_WINDOWS));
        menu.add(show);
        JMenu items = new JMenu("Items table");
        items.add(this.getMenuItem(SELECT_VERTEX_TABLE_COLUMNS, SELECT_VERTEX_TABLE_COLUMNS));
        menu.add(items);
        JMenu modules = new JMenu("Module table");
        modules.add(this.getMenuItem(SELECT_MODULE_TABLE_COLUMNS, SELECT_MODULE_TABLE_COLUMNS));
        menu.add(modules);
        JMenu ppp = new JMenu("Parallel partitions");
        ppp.add(this.getMenuItem(ORDER, "Parallel partitions order"));
        JCheckBoxMenuItem l = new JCheckBoxMenuItem(SHOW_PARTITION_LABELS);
        l.setSelected(true);
        l.getAccessibleContext().setAccessibleDescription("Show partition labels in the Parallel Partitions plot");
        l.addActionListener(this);
        ppp.add(l);
        l = new JCheckBoxMenuItem(SHOW_ITEM_LABELS);
        l.setSelected(true);
        l.getAccessibleContext().setAccessibleDescription("Show item labels in the Parallel Partitions plot");
        l.addActionListener(this);
        ppp.add(l);
        menu.add(ppp);
        this.add(menu);
    }

    private void createMatrixMenu() {
        JMenu fileMenu = new JMenu("Matrix");
        fileMenu.setMnemonic(77);
        fileMenu.getAccessibleContext().setAccessibleDescription("Matrix operations");
        this.add(fileMenu);
        fileMenu.add(this.getMenuItem("Zoom in", 521, 1, "Zoom in on the matrix"));
        fileMenu.add(this.getMenuItem("Zoom out", 45, 1, "Zoom in on the matrix"));
        fileMenu.addSeparator();
        this.highlightItem = new JCheckBoxMenuItem(HIGHLIGHT_CORES);
        this.highlightItem.setSelected(false);
        this.highlightItem.setMnemonic(72);
        this.highlightItem.getAccessibleContext().setAccessibleDescription(HIGHLIGHT_CORES);
        this.highlightItem.addActionListener(this);
        fileMenu.add(this.highlightItem);
        this.overlayItem = new JCheckBoxMenuItem(OVERLAY_EDGE_COUNTS);
        this.overlayItem.setEnabled(false);
        this.overlayItem.setSelected(false);
        this.overlayItem.getAccessibleContext().setAccessibleDescription(OVERLAY_EDGE_COUNTS);
        this.overlayItem.addActionListener(this);
        fileMenu.add(this.overlayItem);
        fileMenu.addSeparator();
        this.baseMenu = new JMenu(CHOOSE_BASE);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rb = new JRadioButtonMenuItem("None");
        rb.setSelected(true);
        rb.addActionListener(this);
        group.add(rb);
        this.baseMenu.add(rb);
        this.baseMenu.addSeparator();
        if (this._dataModel != null && this._dataModel.getClusterings() != null) {
            for (Clustering c : this._dataModel.getClusterings().values()) {
                rb = new JRadioButtonMenuItem(c.getName());
                rb.setSelected(true);
                group.add(rb);
                this.baseMenu.add(rb);
            }
        }
        fileMenu.add(this.baseMenu);
        JMenuItem item = new JMenuItem(REORDER, 82);
        item.addActionListener(this);
        fileMenu.add(item);
    }

    private void createHelpMenu() {
        JMenu fileMenu = new JMenu("Help");
        fileMenu.setMnemonic(72);
        fileMenu.getAccessibleContext().setAccessibleDescription("Help menu");
        this.add(fileMenu);
        fileMenu.add(this.getMenuItem(GO_TO_WEBPAGE, "Open a saved session"));
        fileMenu.add(this.getMenuItem(ABOUT, "Version"));
    }

    private JMenuItem getMenuItem(String label, int keyStroke, int mask, String desc) {
        JMenuItem menuItem = new JMenuItem(label, keyStroke);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyStroke, mask));
        menuItem.getAccessibleContext().setAccessibleDescription(desc);
        menuItem.addActionListener(this);
        return menuItem;
    }

    private JMenuItem getMenuItem(String label, String desc) {
        JMenuItem menuItem = new JMenuItem(label);
        menuItem.getAccessibleContext().setAccessibleDescription(desc);
        menuItem.addActionListener(this);
        return menuItem;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem = (JMenuItem)e.getSource();
        int mnemonic = menuItem.getMnemonic();
        String label = menuItem.getText();
        switch (mnemonic) {
            case 79: {
                this.openClusteringsDialog();
                break;
            }
            case 78: {
                this.openNetworkDialog();
                break;
            }
            case 521: {
                this.zooomIn();
                break;
            }
            case 45: {
                this.zoomOut();
                break;
            }
            case 65: {
                this.loadArabidopsisNetwork();
                break;
            }
            case 75: {
                this.loadKarateNetwork();
                break;
            }
            case 68: {
                this.loadDavesNetwork();
                break;
            }
            case 81: {
                Properties props = new Properties();
                if (this._dataModel.getLastPath() != null) {
                    props.put("DEFAULT_PATH", this._dataModel.getLastPath());
                }
                try {
                    FileOutputStream out = new FileOutputStream("defaultProperties");
                    props.store(out, "---No Comment---");
                    out.close();
                }
                catch (FileNotFoundException e1) {
                    System.out.println("Failed to write properties file");
                }
                catch (IOException e2) {
                    System.out.println("Failed to write properties file");
                }
                System.exit(1);
            }
        }
        if (e.getSource() instanceof JRadioButtonMenuItem) {
            JRadioButtonMenuItem btn = (JRadioButtonMenuItem)e.getSource();
            this.handleBaseClusteringSelection(btn);
        }
        if (label.equals(ABOUT)) {
            this.showAboutDialog();
        } else if (label.equals(GO_TO_WEBPAGE)) {
            this.goToCoralPage();
        } else if (label.equals(SAVE_MATRIX)) {
            int x = menuItem.getX();
            int y = menuItem.getY();
            this.openSaveMatrixDialog(x, y);
        } else if (label.equals(SAVE_CORES)) {
            this.saveCores();
        } else if (!label.equals(SAVE_FIGURE) && !label.equals(SEARCH)) {
            if (label.equals(HIGHLIGHT_CORES)) {
                this.highlightCliques();
            } else if (label.equals(OVERLAY_EDGE_COUNTS)) {
                this.overlayNetData();
            } else if (label.equals(REORDER)) {
                this.showReorderingDialog();
            } else if (label.equals(RESET_WINDOWS)) {
                this.resetWindows();
            } else if (label.equals(SELECT_VERTEX_TABLE_COLUMNS)) {
                this.openSelectTableColumnsDialog("v2vTable");
            } else if (label.equals(SELECT_MODULE_TABLE_COLUMNS)) {
                this.openSelectTableColumnsDialog("c2cTable");
            } else if (label.equals(SHOW_ITEM_LABELS)) {
                this._dataModel.setShowPItems(((JCheckBoxMenuItem)menuItem).isSelected());
            } else if (label.equals(SHOW_PARTITION_LABELS)) {
                this._dataModel.setShowPLabels(((JCheckBoxMenuItem)menuItem).isSelected());
            } else if (label.equals(ORDER)) {
                this.openParParOrderDialog();
            }
        }
    }

    private void saveCores() {
        JFrame frame = this._dataModel.getMainWindow();
        Collection<Clique> cliques = this._dataModel.getCliques();
        SaveCoresDialog dialog = new SaveCoresDialog(frame, cliques);
        dialog.pack();
        Point p = frame.getLocationOnScreen();
        Rectangle r = frame.getBounds();
        Dimension d = dialog.getPreferredSize();
        int x = p.x + (int)Math.floor(((double)r.width - d.getWidth()) / 2.0);
        int y = p.y + (int)Math.floor(((double)r.height - d.getHeight()) / 2.0);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
    }

    private void goToCoralPage() {
        String htmlAddr = CORAL_URL;
        try {
            URL url = new URL(htmlAddr);
            if (!Desktop.isDesktopSupported()) {
                System.out.println("Desktop operations (browsing) are not supported.");
                return;
            }
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (MalformedURLException e1) {
            System.out.println("here1");
            e1.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("here2");
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            System.out.println("here3");
            e.printStackTrace();
        }
    }

    private void showAboutDialog() {
        JFrame frame = this._dataModel.getMainWindow();
        AboutDialog dialog = new AboutDialog(frame);
        dialog.pack();
        Point p = frame.getLocationOnScreen();
        Rectangle r = frame.getBounds();
        Dimension d = dialog.getPreferredSize();
        int x = p.x + (int)Math.floor(((double)r.width - d.getWidth()) / 2.0);
        int y = p.y + (int)Math.floor(((double)r.height - d.getHeight()) / 2.0);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
    }

    private void handleBaseClusteringSelection(JRadioButtonMenuItem btn) {
        String txt = btn.getText();
        if (txt.equals("None")) {
            this._dataModel.setBaseClustering(null);
            Matrix cm = this._dataModel.getCurrentMatrix();
            Matrix reordered = null;
            if (cm instanceof BaseMatrix) {
                reordered = ((BaseMatrix)cm).getDataMatrix();
            } else {
                Clustering c = this._dataModel.getClusterings().values().iterator().next();
                BitSymmetricMatrix base = c.getCoocurenceMatrix();
                MyMTJMatrix sum = new MyMTJMatrix(base.columnNames, base.columnNames);
                for (Clustering clust : this._dataModel.getClusterings().values()) {
                    sum.addMatrix(clust.getCoocurenceMatrix());
                }
                reordered = Matrix.reorderSubMatrix(sum, cm);
            }
            this._dataModel.setCurrentMatrix(reordered);
        } else {
            Map<String, Clustering> clusterings = this._dataModel.getClusterings();
            Clustering c = clusterings.get(txt);
            this._dataModel.setBaseClustering(c);
            BaseMatrix m = this.computeBaseClustering(c, clusterings, this._dataModel.getCurrentMatrix());
            this._dataModel.setCurrentMatrix(m);
        }
    }

    private BaseMatrix computeBaseClustering(Clustering c, Map<String, Clustering> clusterings, Matrix refM) {
        System.out.println("Computing base clsutering for " + c.getName());
        int s = refM.getColumnCount();
        double[][] data = new double[s][s];
        int i = 0;
        while (i < s) {
            int j = i;
            while (j < s) {
                double d = refM.getElement(i, j);
                data[j][i] = d;
                data[i][j] = d;
                ++j;
            }
            ++i;
        }
        MyMTJMatrix ref = new MyMTJMatrix(data, refM.rowNames, refM.columnNames, refM.getMax());
        BitSymmetricMatrix base = c.getCoocurenceMatrix();
        MyMTJMatrix sum = new MyMTJMatrix(base.columnNames, base.columnNames);
        for (Clustering clust : clusterings.values()) {
            BitSymmetricMatrix bsm = clust.getCoocurenceMatrix();
            int i2 = 0;
            while (i2 < base.getColumnCount()) {
                if (bsm.columnNames[i2] != base.columnNames[i2]) {
                    System.out.println("not equals");
                }
                ++i2;
            }
            BitSymmetricMatrix filteredMatrix = BitSymmetricMatrix.filter(base, bsm);
            sum.addMatrix(filteredMatrix);
        }
        MyMTJMatrix baseCont = MyMTJMatrix.reorderSubMatrix(sum, refM);
        this.getStats(c, baseCont);
        BaseMatrix baseMatrix = null;
        try {
            baseMatrix = new BaseMatrix(ref, baseCont);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baseMatrix;
    }

    private void getStats(Clustering clust, MyMTJMatrix baseCont) {
        ArrayList<Integer> counts = new ArrayList<Integer>();
        int i = 0;
        while (i < this._dataModel.getClusterings().size() + 1) {
            counts.add(0);
            ++i;
        }
        for (MatrixEntry me : baseCont.getMatrix()) {
            int c = (int)me.get();
            if (counts.get(c) == null) {
                counts.set(c, 1);
                continue;
            }
            counts.set(c, (Integer)counts.get(c) + 1);
        }
    }

    private void loadArabidopsisNetwork() {
        this._dataModel.reset();
        String baseName = "..\\..\\..\\..\\write\\coral\\arabidopsis\\analysis\\ai_main\\filt_size_pd\\";
        String[] fNames = new String[]{"A.Thal_original", "BLONDEL.filt", "CFINDER.filt", "CLAUSET.filt", "MCL.filt", "MCODE.F.filt", "MCODE.filt", "MINE.filt", "SPICi.filt"};
        baseName = baseName.replace('\\', File.separatorChar);
        int N = fNames.length;
        int i = 0;
        while (i < N) {
            fNames[i] = String.valueOf(baseName) + fNames[i];
            ++i;
        }
        FileParserProgressDialog dialog = new FileParserProgressDialog(this._dataModel, fNames);
        dialog.pack();
        JFrame frame = this._dataModel.getMainWindow();
        Point p = frame.getLocationOnScreen();
        Rectangle r = frame.getBounds();
        Dimension d = dialog.getPreferredSize();
        int x = p.x + (int)Math.floor(((double)r.width - d.getWidth()) / 2.0);
        int y = p.y + (int)Math.floor(((double)r.height - d.getHeight()) / 2.0);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
    }

    private void showReorderingDialog() {
        JFrame frame = this._dataModel.getMainWindow();
        ReorderMatrixDialog dialog = new ReorderMatrixDialog(frame, this._dataModel);
        dialog.pack();
        Point p = frame.getLocationOnScreen();
        Rectangle r = frame.getBounds();
        Dimension d = dialog.getPreferredSize();
        int x = p.x + (int)Math.floor(((double)r.width - d.getWidth()) / 2.0);
        int y = p.y + (int)Math.floor(((double)r.height - d.getHeight()) / 2.0);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
    }

    private void zoomOut() {
        float zoom = this._dataModel.getZoomValue();
        this._dataModel.setZoomValue(zoom - 0.2f);
    }

    private void zooomIn() {
        float zoom = this._dataModel.getZoomValue();
        this._dataModel.setZoomValue(zoom + 0.2f);
    }

    private void openNetworkDialog() {
        JFileChooser fc = new JFileChooser(this._dataModel.getLastPath());
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(2);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            EdgeFileParser m = new EdgeFileParser();
            m.parse(f.getAbsolutePath(), this._dataModel);
        }
    }

    private void resetWindows() {
        View[] views;
        System.out.println("Resetting windows");
        View[] viewArray = views = this._dataModel.getViews();
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            View v = viewArray[n2];
            System.out.println("restoring " + v.getTitle());
            if (v.getRootWindow() != null) {
                v.restore();
            } else {
                DockingUtil.addWindow((DockingWindow)v, (RootWindow)this.rootWindow);
            }
            ++n2;
        }
    }

    private void openSelectTableColumnsDialog(String tableName) {
        Window dialog = null;
        if (tableName.equals("v2vTable")) {
            dialog = new SelectColumnsDialog(this._dataModel, Vertex2VertexTableModel.getColumnNames(), tableName);
        } else if (tableName.equals("c2cTable")) {
            System.out.println("c2c");
            dialog = new SelectColumnsDialog(this._dataModel, ClusteringCompareTableModel.getColumnNames(), tableName);
        }
        dialog.pack();
        JFrame frame = this._dataModel.getMainWindow();
        Point p = frame.getLocationOnScreen();
        Rectangle r = frame.getBounds();
        Dimension d = dialog.getPreferredSize();
        int x = p.x + (int)Math.floor(((double)r.width - d.getWidth()) / 2.0);
        int y = p.y + (int)Math.floor(((double)r.height - d.getHeight()) / 2.0);
        dialog.setLocation(x, y);
        ((Dialog)dialog).setVisible(true);
    }

    private void openParParOrderDialog() {
        SelectClusteringOrderDialog dialog = null;
        dialog = new SelectClusteringOrderDialog(this._dataModel);
        dialog.pack();
        JFrame frame = this._dataModel.getMainWindow();
        Point p = frame.getLocationOnScreen();
        Rectangle r = frame.getBounds();
        Dimension d = dialog.getPreferredSize();
        int x = p.x + (int)Math.floor(((double)r.width - d.getWidth()) / 2.0);
        int y = p.y + (int)Math.floor(((double)r.height - d.getHeight()) / 2.0);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
    }

    private void openSaveMatrixDialog(int x, int y) {
        SaveMatrixDialog dialog = new SaveMatrixDialog(this._dataModel, x, y);
        dialog.setDefaultCloseOperation(0);
        dialog.pack();
        JFrame frame = this._dataModel.getMainWindow();
        Point p = frame.getLocationOnScreen();
        Rectangle r = frame.getBounds();
        Dimension d = dialog.getPreferredSize();
        int x_diag = p.x + (int)Math.floor(((double)r.width - d.getWidth()) / 2.0);
        int y_diag = p.y + (int)Math.floor(((double)r.height - d.getHeight()) / 2.0);
        dialog.setLocation(x_diag, y_diag);
        dialog.setVisible(true);
    }

    private void highlightCliques() {
        this._dataModel.setHighlightCliques(!this._dataModel.getHighlightCliques());
        if (!this._dataModel.getHighlightCliques()) {
            this.overlayItem.setEnabled(false);
            this._dataModel.setOverlayCliques(false);
        }
        if (this._dataModel.getHighlightCliques()) {
            MatrixCollapseManager m = new MatrixCollapseManager(this._dataModel);
            m.execute();
        }
    }

    private void overlayNetData() {
        this._dataModel.setOverlayCliques(!this._dataModel.getOverlayCliques());
    }

    private void openClusteringsDialog() {
        String path = this._dataModel.getLastPath();
        if (path == null || path.equals("")) {
            path = ".";
        }
        JFileChooser fc = new JFileChooser(path);
        fc.setMultiSelectionEnabled(true);
        fc.setFileSelectionMode(2);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File[] files = fc.getSelectedFiles();
            this._dataModel.setLastPath(files[0].getParent());
            ClusteringsManager m = new ClusteringsManager(this._dataModel, files);
            m.execute();
        }
    }

    private void loadKarateNetwork() {
        this._dataModel.reset();
        int N = 10;
        String baseName = "..\\data\\karate_club\\clusterings\\";
        String[] fNames = new String[N];
        baseName = baseName.replace('\\', File.separatorChar);
        int i = 0;
        while (i < N) {
            fNames[i] = String.valueOf(baseName) + Integer.valueOf(i).toString();
            ++i;
        }
        FileParserProgressDialog dialog = new FileParserProgressDialog(this._dataModel, fNames);
        dialog.pack();
        JFrame frame = this._dataModel.getMainWindow();
        Point p = frame.getLocationOnScreen();
        Rectangle r = frame.getBounds();
        Dimension d = dialog.getPreferredSize();
        int x = p.x + (int)Math.floor(((double)r.width - d.getWidth()) / 2.0);
        int y = p.y + (int)Math.floor(((double)r.height - d.getHeight()) / 2.0);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
    }

    private void loadDavesNetwork() {
        this._dataModel.reset();
        String[] fileNames = new String[]{"..\\data\\dave\\arthur.mods", "..\\data\\dave\\pgs.mods", "..\\data\\dave\\bandyo.mods", "..\\data\\dave\\us.mods"};
        int i = 0;
        while (i < fileNames.length) {
            fileNames[i] = fileNames[i].replace('\\', File.separatorChar);
            ++i;
        }
        FileParserProgressDialog dialog = new FileParserProgressDialog(this._dataModel, fileNames);
        dialog.pack();
        JFrame frame = this._dataModel.getMainWindow();
        Point p = frame.getLocationOnScreen();
        Rectangle r = frame.getBounds();
        Dimension d = dialog.getPreferredSize();
        int x = p.x + (int)Math.floor(((double)r.width - d.getWidth()) / 2.0);
        int y = p.y + (int)Math.floor(((double)r.height - d.getHeight()) / 2.0);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        try {
            boolean generateCliques;
            boolean load_network = false;
            if (load_network) {
                String fileName = "..\\data\\dave\\chromosome-emap.edg";
                fileName = fileName.replace('\\', File.separatorChar);
                EdgeFileParser netParser = new EdgeFileParser();
                netParser.parse(fileName, this._dataModel);
                this._dataModel.firePropertyChange("networkLoaded", false, true);
            }
            if (generateCliques = false) {
                LooseCliqueFinder cliqueLoose = new LooseCliqueFinder(this._dataModel);
                cliqueLoose.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Data loading error", 0);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String eventName = e.getPropertyName();
        if (eventName.equals("highlightCliquesChanged")) {
            this.highlightItem.setSelected(this._dataModel.getHighlightCliques());
            if (this._dataModel.hasEdges()) {
                this.overlayItem.setEnabled(true);
            }
        } else if (eventName.equals("overlayCliques")) {
            this.overlayItem.setSelected(this._dataModel.getOverlayCliques());
        } else if (eventName.equals("edgesChanged")) {
            if (this._dataModel.hasEdges() && this._dataModel.getHighlightCliques()) {
                this.overlayItem.setEnabled(true);
            } else {
                this.overlayItem.setEnabled(false);
            }
        } else if (eventName.equals("clusteringsChanged")) {
            this.baseMenu.removeAll();
            ButtonGroup group = new ButtonGroup();
            JRadioButtonMenuItem rb = new JRadioButtonMenuItem("None");
            rb.setSelected(true);
            rb.addActionListener(this);
            group.add(rb);
            this.baseMenu.add(rb);
            this.baseMenu.addSeparator();
            if (this._dataModel.getClusterings() != null) {
                Map<String, Clustering> map = this._dataModel.getClusterings();
                Collection<Clustering> clusterings = map.values();
                ArrayList<Clustering> list = new ArrayList<Clustering>(clusterings);
                Collections.sort(list);
                for (Clustering c : list) {
                    rb = new JRadioButtonMenuItem(c.getName());
                    rb.addActionListener(this);
                    rb.setSelected(true);
                    group.add(rb);
                    this.baseMenu.add(rb);
                }
            }
        }
    }

    public void windowAdded(DockingWindow addedToWindow, DockingWindow addedWindow) {
        this.updateViews(addedWindow, true);
    }

    public void windowRemoved(DockingWindow removedFromWindow, DockingWindow removedWindow) {
        this.updateViews(removedWindow, false);
    }

    public void windowClosing(DockingWindow window) throws OperationAbortedException {
    }

    public void windowDocking(DockingWindow window) throws OperationAbortedException {
    }

    public void windowUndocking(DockingWindow window) throws OperationAbortedException {
    }

    private void updateViews(DockingWindow window, boolean added) {
        if (window instanceof View) {
            View[] views = this._dataModel.getViews();
            int i = 0;
            while (i < views.length) {
                if (views[i] == window && this.viewItems[i] != null) {
                    this.viewItems[i].setEnabled(!added);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < window.getChildWindowCount()) {
                this.updateViews(window.getChildWindow(i), added);
                ++i;
            }
        }
    }

    public void viewFocusChanged(View arg0, View arg1) {
    }

    public void windowClosed(DockingWindow arg0) {
    }

    public void windowDocked(DockingWindow arg0) {
    }

    public void windowHidden(DockingWindow arg0) {
    }

    public void windowMaximized(DockingWindow arg0) {
    }

    public void windowMaximizing(DockingWindow arg0) throws OperationAbortedException {
    }

    public void windowMinimized(DockingWindow arg0) {
    }

    public void windowMinimizing(DockingWindow arg0) throws OperationAbortedException {
    }

    public void windowRestored(DockingWindow arg0) {
    }

    public void windowRestoring(DockingWindow arg0) throws OperationAbortedException {
    }

    public void windowShown(DockingWindow arg0) {
    }

    public void windowUndocked(DockingWindow arg0) {
    }
}

