/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.parse;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.model.parse.FormatException;
import edu.umd.coral.model.parse.Parser;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleFilesParser
extends Parser {
    public static final String GRAB_BAG = "__misc__";
    public static final Color[] band_colors = new Color[]{new Color(141, 211, 199), new Color(254, 224, 144), new Color(190, 186, 218), new Color(128, 177, 211), new Color(253, 180, 98), new Color(179, 222, 105), new Color(252, 205, 229), new Color(217, 217, 217), new Color(191, 129, 45), new Color(128, 205, 193), new Color(53, 151, 143), new Color(254, 178, 76), new Color(128, 115, 172), new Color(178, 171, 210), new Color(224, 130, 20), new Color(90, 174, 97), new Color(27, 120, 55), new Color(153, 112, 171)};

    public static Color getColor(int i) {
        return band_colors[i % band_colors.length];
    }

    public void parse(String[] fileNames, DataModel model) throws Exception {
        long timeBefore = System.currentTimeMillis();
        ArrayList<Vertex> initialOrder = new ArrayList<Vertex>();
        this.vertexIndex = 0;
        try {
            Module module;
            String clusteringName;
            int i = 0;
            while (i < fileNames.length) {
                String line;
                this.vertexCount = 0;
                File f = new File(fileNames[i]);
                InputStreamReader fis = new InputStreamReader(new FileInputStream(f));
                BufferedReader br = new BufferedReader(fis);
                clusteringName = f.getName().endsWith(".txt") ? f.getName().replace(".txt", "") : (f.getName().endsWith(".clust") ? f.getName().replace(".clust", "") : f.getName());
                Clustering c = new Clustering(clusteringName);
                c.setColor(ModuleFilesParser.getColor(i));
                this.clusterings.put(clusteringName, c);
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    this.parseModule(c, line, initialOrder);
                }
                c.setOriginalVertexCount(this.vertexCount);
                br.close();
                fis.close();
                ++i;
            }
            if (model.getAggregateSingletons()) {
                for (Clustering clustering : this.clusterings.values()) {
                    clustering.recordOriginalModuleCount();
                    clusteringName = clustering.getName();
                    module = new Module(GRAB_BAG, clustering);
                    for (Vertex u : this.vertices.values()) {
                        if (clustering.hasVertex(u)) continue;
                        System.out.println("added a vertex to grab bag");
                        module.addVertex(u);
                    }
                    if (module.getSize() <= 0) continue;
                    System.out.println("added grab bag to " + clustering.getName() + " size " + module.getSize());
                    clustering.addModule(module);
                }
            } else {
                for (Object clustering : this.clusterings.values()) {
                    ((Clustering)clustering).recordOriginalModuleCount();
                    clusteringName = ((Clustering)clustering).getName();
                    for (Vertex u : this.vertices.values()) {
                        if (((Clustering)clustering).hasVertex(u)) continue;
                        String vertexName = u.getName();
                        module = new Module(String.valueOf(vertexName) + "_singl", true, (Clustering)clustering);
                        module.addVertex(u);
                        ((Clustering)clustering).addModule(module);
                    }
                }
            }
            for (Clustering clu : this.clusterings.values()) {
                System.out.println(String.valueOf(clu.getVertexCount()) + " " + clu.getOriginalVertexCount());
            }
            model.setInitialVertexOrder(initialOrder);
            model.setVertices(this.vertices);
            model.setClusterings(this.clusterings);
            ArrayList<Clustering> ordering = new ArrayList<Clustering>(this.clusterings.values());
            Collections.sort(ordering);
            model.setClusteringOrdering(ordering);
            model.firePropertyChange("networkLoaded", false, true);
            long timeAfter = System.currentTimeMillis();
            System.out.println("Time to load data: " + (timeAfter - timeBefore) + "ms");
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found");
            e.printStackTrace();
        }
        catch (IOException e2) {
            System.out.println("IOException");
            e2.printStackTrace();
        }
        catch (NullPointerException e3) {
            System.out.println("null pointer");
            e3.printStackTrace();
        }
        catch (FormatException e) {
            e.printStackTrace();
        }
    }

    private void parseModule(Clustering c, String line, ArrayList<Vertex> initialOrder) throws Exception {
        String[] columns = line.split("[ \t\b\n\f\r]");
        if (columns.length < 2) {
            System.out.println("bad module");
            throw new FormatException(c.getName(), "", line);
        }
        System.out.println("-----");
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            System.out.print(String.valueOf(part) + "**");
            ++n2;
        }
        System.out.println("-----");
        String moduleName = columns[0].trim();
        Module module = new Module(moduleName, c);
        int j = 1;
        while (j < columns.length) {
            Vertex v;
            String vertexName = columns[j].trim();
            if (this.vertices.containsKey(vertexName)) {
                v = (Vertex)this.vertices.get(vertexName);
                if (!c.containsVertex(v)) {
                    ++this.vertexCount;
                }
            } else {
                v = new Vertex(vertexName, this.vertexIndex);
                this.vertices.put(vertexName, v);
                ++this.vertexIndex;
                ++this.vertexCount;
                initialOrder.add(v);
            }
            module.addVertex(v);
            ++j;
        }
        c.addModule(module);
    }
}

