/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.metrics;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.metrics.Entropy;
import edu.umd.coral.model.metrics.Metric;
import edu.umd.coral.model.metrics.MutualInformation;

public class VariationOfInformation
implements Metric {
    public float getScore(Clustering c1, Clustering c2, boolean includeGrabBag) throws Exception {
        float H1 = Entropy.getEntropy(c1, includeGrabBag);
        float H2 = Entropy.getEntropy(c2, includeGrabBag);
        MutualInformation mutual = new MutualInformation();
        float I12 = mutual.getScore(c1, c2, includeGrabBag);
        return H1 + H2 - 2.0f * I12;
    }

    public String getName() {
        return "Variation of information";
    }

    public String toString() {
        return "Variation of information";
    }

    public String getAnnotation() {
        return "<html><b>Variation of Information</b> - a measure of the amount of information<br>lost and gained when changing from one clustering to the other</html>";
    }
}

