/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.metrics;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.metrics.Metric;

public class PurityMetric
implements Metric {
    public String getName() {
        return "Purity";
    }

    public float getScore(Clustering experiment, Clustering truth, boolean includeGrabBag) {
        float sum = 0.0f;
        for (Module c_i : experiment.getModules()) {
            if (!includeGrabBag && c_i.getName().equals("__misc__")) continue;
            float precision = 0.0f;
            float max = 0.0f;
            for (Module l_j : truth.getModules()) {
                if (!includeGrabBag && l_j.getName().equals("__misc__") || !((precision = (float)l_j.getIntersection(c_i).size() * 1.0f) > max)) continue;
                max = precision;
            }
            sum += max;
        }
        return sum / (float)experiment.getVertexCount();
    }

    public String toString() {
        return "Purity";
    }

    public String getAnnotation() {
        return "<html><b>Purity</b> - assumming that one clustering is obtained through an experiment <br>and another one represents the truth, shows how close the experimental modules are<br>to only containing elements of the same category</html>";
    }
}

