/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.metrics;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.Vertex;
import java.util.ArrayList;
import java.util.TreeSet;

public class Overlap {
    public static float getOverlap(Clustering c, boolean includeGrabBag) {
        ArrayList<Module> mods = new ArrayList<Module>(c.getModules());
        TreeSet<Vertex> overlapping = new TreeSet<Vertex>();
        int vert_cnt = c.getOriginalVertexCount();
        int i = 0;
        while (i < mods.size()) {
            Module m1 = mods.get(i);
            if (includeGrabBag || !m1.getName().equals("__misc__")) {
                int j = i + 1;
                while (j < mods.size()) {
                    Module m2 = mods.get(j);
                    if (includeGrabBag || !m2.getName().equals("__misc__")) {
                        overlapping.addAll(m1.getIntersection(m2));
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (vert_cnt == 0) {
            return 0.0f;
        }
        return (float)overlapping.size() * 1.0f / (float)vert_cnt;
    }
}

