/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.metrics;

import edu.umd.coral.model.data.BitSymmetricMatrix;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.model.metrics.Metric;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaccardMetric
implements Metric {
    @Override
    public float getScore(Clustering c1, Clustering c2, boolean includeGrabBag) {
        float jac = BitSymmetricMatrix.jaccard(c1.getCoocurenceMatrix(), c2.getCoocurenceMatrix(), includeGrabBag);
        return jac;
    }

    public float getScore(Collection<Vertex> c1, Collection<Vertex> c2) {
        if (c1 == null || c2 == null) {
            return 0.0f;
        }
        Iterator<Vertex> iterator = c1.iterator();
        int intersectionSize = 0;
        while (iterator.hasNext()) {
            if (!c2.contains(iterator.next())) continue;
            ++intersectionSize;
        }
        int unionSize = c1.size() + c2.size() - intersectionSize;
        float score = (float)intersectionSize * 1.0f / (float)unionSize;
        return score;
    }

    @Override
    public String getName() {
        return "Jaccard";
    }

    public String toString() {
        return "Jaccard";
    }

    @Override
    public String getAnnotation() {
        return "<html><b>Jaccard</b> - a measure of how many pairs were placed in the same<br>cluster in both clusterings</html>";
    }
}

