/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.metrics;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.metrics.Metric;

public class FMeasureMetric
implements Metric {
    public String getName() {
        return "F-measure";
    }

    public float getScore(Clustering truth, Clustering experiment, boolean includeGrabBag) {
        int N = truth.getVertexCount();
        assert (truth.getVertexCount() == experiment.getVertexCount());
        float sum = 0.0f;
        for (Module l_i : truth.getModules()) {
            if (!includeGrabBag && l_i.getName().equals("__misc__")) continue;
            float max = 0.0f;
            for (Module c_j : experiment.getModules()) {
                float f_score;
                if (!includeGrabBag && c_j.getName().equals("__misc__") || !((f_score = this.fScore(l_i, c_j)) > max)) continue;
                max = f_score;
            }
            sum += max * (float)l_i.getSize();
        }
        return sum * 2.0f / (float)N;
    }

    private float fScore(Module l, Module c) {
        return this.recall(l, c) * this.precision(l, c) / (this.recall(l, c) + this.precision(l, c));
    }

    private float precision(Module c, Module l) {
        return (float)c.getIntersection(l).size() * 1.0f / (float)c.getSize();
    }

    private float recall(Module c, Module l) {
        return this.precision(l, c);
    }

    public String toString() {
        return "F-measure";
    }

    public String getAnnotation() {
        return "<html><b>F-measure</b> - measure based on recall and precision assuming<br> that one of the clsuterings is a true decomposition</html>";
    }
}

