/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.data;

import edu.umd.coral.model.data.BitSymmetricMatrix;
import edu.umd.coral.model.data.Matrix;
import java.io.BufferedWriter;
import java.io.IOException;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;

public class MyMTJMatrix
extends Matrix {
    private FlexCompRowMatrix matrix;

    public MyMTJMatrix(int size) {
        super(size, size);
        this.matrix = new FlexCompRowMatrix(size, size);
    }

    public MyMTJMatrix(double[][] data, String[] rowNames, String[] columnNames, double max) {
        super(rowNames, columnNames);
        super.setMax((float)max);
        DenseMatrix dense = new DenseMatrix(data);
        this.matrix = new FlexCompRowMatrix((no.uib.cipr.matrix.Matrix)dense, true);
    }

    public MyMTJMatrix(double[][] data, int size) {
        DenseMatrix dense = new DenseMatrix(data);
        this.matrix = new FlexCompRowMatrix((no.uib.cipr.matrix.Matrix)dense, true);
    }

    public MyMTJMatrix(double[][] data, String[] rowNames, String[] columnNames) {
        super(rowNames, columnNames);
        DenseMatrix dense = new DenseMatrix(data);
        this.matrix = new FlexCompRowMatrix((no.uib.cipr.matrix.Matrix)dense, true);
    }

    public MyMTJMatrix(String[] rowNames, String[] columnNames) {
        super(rowNames, columnNames);
        this.matrix = new FlexCompRowMatrix(rowNames.length, columnNames.length);
    }

    public MyMTJMatrix(FlexCompRowMatrix m, String[] col_names, String[] row_names) {
        this.columnNames = col_names;
        this.rowNames = row_names;
        this.column_count = col_names.length;
        this.row_count = row_names.length;
        this.matrix = m;
    }

    public int getSize() {
        if (this.matrix != null) {
            return this.matrix.numColumns();
        }
        return 0;
    }

    public double getElement(int i, int j) {
        return (float)this.matrix.get(i, j);
    }

    public void setElement(int r, int c, int value) {
        this.matrix.set(r, c, (double)value);
    }

    public MyMTJMatrix addMatrix(BitSymmetricMatrix m) {
        int i = 0;
        while (i < this.row_count) {
            int j = 0;
            while (j < this.column_count) {
                this.matrix.set(i, j, this.matrix.get(i, j) + m.getElement(i, j));
                if (this.matrix.get(i, j) > this.getMax()) {
                    super.setMax((float)this.matrix.get(i, j));
                }
                ++j;
            }
            ++i;
        }
        return this;
    }

    public MyMTJMatrix addMatrix(MyMTJMatrix m) {
        if (m.getColumnCount() != this.column_count || m.getRowCount() != this.row_count) {
            throw new IndexOutOfBoundsException();
        }
        no.uib.cipr.matrix.Matrix sum = this.matrix.add((no.uib.cipr.matrix.Matrix)m.matrix);
        MyMTJMatrix temp = new MyMTJMatrix(this.column_count);
        temp.matrix = new FlexCompRowMatrix(sum, false);
        return temp;
    }

    public FlexCompRowMatrix getMatrix() {
        return this.matrix;
    }

    protected MyMTJMatrix makeMatrix(double[][] data, String[] rowNames, String[] colNames, double max) {
        MyMTJMatrix j = new MyMTJMatrix(data, rowNames, colNames, max);
        return j;
    }

    protected MyMTJMatrix makeMatrix(double[][] data, String[] rowNames, String[] columnNames) {
        MyMTJMatrix j = new MyMTJMatrix(data, rowNames, columnNames);
        return j;
    }

    public BufferedWriter saveToFileAsCSVMatrix(BufferedWriter bf, String delimiter) throws IOException {
        bf.write(delimiter);
        int j = 0;
        while (j < this.getSize()) {
            bf.write("'" + this.getColumnName(j) + "'");
            if (j < this.getSize() - 1) {
                bf.write(delimiter);
            }
            ++j;
        }
        bf.write("\n");
        int i = 0;
        while (i < this.getSize()) {
            j = 0;
            while (j < this.getSize()) {
                bf.write(String.valueOf(this.matrix.get(i, j)));
                if (j < this.getSize() - 1) {
                    bf.write(delimiter);
                }
                ++j;
            }
            bf.write("\n");
            ++i;
        }
        return bf;
    }

    public static MyMTJMatrix reorderSubMatrix(Matrix matrix, Matrix referenceMatrix) {
        if (matrix == null || referenceMatrix == null) {
            return null;
        }
        int rowCount = matrix.getRowCount();
        String[] names = new String[rowCount];
        double[][] data = new double[rowCount][rowCount];
        int i = 0;
        while (i < rowCount) {
            String rowName = referenceMatrix.getRowName(i);
            int oldRowIndex = matrix.getRowIndex(rowName);
            names[i] = rowName;
            int j = 0;
            while (j < rowCount) {
                String columnName = referenceMatrix.getColumnName(j);
                int oldColumnIndex = matrix.getColumnIndex(columnName);
                data[i][j] = matrix.getElement(oldRowIndex, oldColumnIndex);
                ++j;
            }
            ++i;
        }
        MyMTJMatrix m = new MyMTJMatrix(data, names, names, matrix.getMax());
        return m;
    }

    public static /* bridge */ /* synthetic */ Matrix reorderSubMatrix(Matrix matrix, Matrix matrix2) {
        return MyMTJMatrix.reorderSubMatrix(matrix, matrix2);
    }
}

