/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.data;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Named;
import edu.umd.coral.model.data.Pair;
import edu.umd.coral.model.data.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module
implements Named,
Comparable<Module> {
    private String _name;
    private Set<Vertex> _vertices = new TreeSet<Vertex>();
    private Vertex[] vertexOrder;
    private Clustering containingClustering;

    public Module(String name, Clustering c) {
        this._name = name;
        this.containingClustering = c;
    }

    public Module(Collection<Vertex> coll, Clustering c) {
        for (Vertex v : coll) {
            this._vertices.add(v);
        }
        this.containingClustering = c;
    }

    public Module(String name, boolean isSingleton, Clustering c) {
        this._name = name;
        this.containingClustering = c;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public Clustering getClustering() {
        return this.containingClustering;
    }

    public int getSize() {
        return this._vertices.size();
    }

    public void addVertex(Vertex u) {
        boolean hasVertex = false;
        for (Vertex v : this._vertices) {
            if (!v.getName().equals(u.getName())) continue;
            hasVertex = true;
        }
        if (this._vertices.contains(u) || hasVertex) {
            System.out.println("ERROR: can not add a duplicate vertex: " + this.getName());
            return;
        }
        this._vertices.add(u);
    }

    public ArrayList<Vertex> getVertices() {
        ArrayList<Vertex> blah = new ArrayList<Vertex>();
        blah.addAll(this._vertices);
        return blah;
    }

    public Set<Vertex> getVertexMap() {
        return this._vertices;
    }

    public String toString() {
        String s = "";
        for (Vertex v : this._vertices) {
            s = String.valueOf(s) + v.getName() + ", ";
        }
        return s.trim();
    }

    public ArrayList<Vertex> getDifference(Module module) {
        ArrayList<Vertex> diff = new ArrayList<Vertex>();
        diff.addAll(this._vertices);
        Iterator<Vertex> iterator = module._vertices.iterator();
        while (iterator.hasNext()) {
            diff.remove(iterator.next());
        }
        return diff;
    }

    public ArrayList<Vertex> getUnion(Module module) {
        ArrayList<Vertex> union = new ArrayList<Vertex>();
        union.addAll(this._vertices);
        for (Vertex v : module._vertices) {
            if (union.contains(v)) continue;
            union.add(v);
        }
        return union;
    }

    public ArrayList<Vertex> getIntersection(Module m2) {
        ArrayList<Vertex> intersection = new ArrayList<Vertex>();
        for (Vertex v : this._vertices) {
            if (!m2._vertices.contains(v)) continue;
            intersection.add(v);
        }
        return intersection;
    }

    public int[][] getIntersectionIndices(Module m2) {
        ArrayList<Vertex> coll = this.getIntersection(m2);
        int[][] indices = new int[coll.size()][2];
        Vertex[] us = this.getVertexMapping();
        Vertex[] vs = m2.getVertexMapping();
        int k = 0;
        int i = 0;
        while (i < us.length) {
            int j = 0;
            while (j < vs.length) {
                if (us[i] == null) {
                    System.out.println("us[i] is null " + this._name);
                }
                if (us[i].equals(vs[j])) {
                    indices[k][0] = i;
                    indices[k][1] = j;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return indices;
    }

    public float getInOutRatio() {
        if (this._vertices == null) {
            return 0.0f;
        }
        int inEdges = 0;
        int outEdges = 0;
        for (Vertex u : this._vertices) {
            Collection<Vertex> neighbors = u.getNeighbors();
            for (Vertex v : neighbors) {
                if (this._vertices.contains(v)) {
                    ++inEdges;
                    continue;
                }
                ++outEdges;
            }
        }
        inEdges /= 2;
        if (outEdges == 0) {
            return 0.0f;
        }
        return inEdges / outEdges;
    }

    public int getEdgeCount() {
        int count = 0;
        for (Vertex v : this._vertices) {
            for (Vertex u : v.getNeighbors()) {
                if (!this._vertices.contains(u)) continue;
                ++count;
            }
        }
        return count / 2;
    }

    public float getExpectedEdgeCount() {
        float sum = 0.0f;
        int m = 0;
        for (Vertex v : this._vertices) {
            m += v.getDegree();
        }
        for (Vertex v : this._vertices) {
            for (Vertex u : v.getNeighbors()) {
                if (!this._vertices.contains(u)) continue;
                sum += (float)(v.getDegree() * u.getDegree()) * 1.0f / (float)m;
            }
        }
        return sum;
    }

    public boolean contains(Vertex v) {
        if (this._vertices == null) {
            return false;
        }
        return this._vertices.contains(v);
    }

    public int getIndex(Vertex v) {
        if (this.vertexOrder == null) {
            return -1;
        }
        int i = 0;
        Vertex[] vertexArray = this.vertexOrder;
        int n = this.vertexOrder.length;
        int n2 = 0;
        while (n2 < n) {
            Vertex u = vertexArray[n2];
            if (u.equals(v)) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public Vertex[] getVertexMapping() {
        return this.vertexOrder;
    }

    public void setVertexMapping(ArrayList<Pair<Vertex, Integer>> l) {
        this.vertexOrder = new Vertex[this.getSize()];
        int i = 0;
        for (Pair<Vertex, Integer> p : l) {
            this.vertexOrder[i++] = p.getKey();
        }
    }

    @Override
    public int compareTo(Module o) {
        return this._name.compareTo(o._name);
    }

    public boolean containsAny(ArrayList<Vertex> selectedVerts) {
        boolean contains = false;
        for (Vertex v : selectedVerts) {
            if (!this._vertices.contains(v)) continue;
            contains = true;
            break;
        }
        return contains;
    }
}

