/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.data;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Vertex;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cooccurrence
implements Comparable<Cooccurrence> {
    public Vertex u;
    public Vertex v;
    private Set<Clustering> clusterings;
    private String signature;
    private String niceString;
    private List<Clustering> lastUsedOrdering;

    public Cooccurrence(Vertex u, Vertex v) {
        this.u = u;
        this.v = v;
    }

    public void setSignature(List<Clustering> ordering) {
        this.lastUsedOrdering = ordering;
        String s = "";
        if (this.clusterings == null) {
            int i = 0;
            while (i < ordering.size()) {
                s = String.valueOf(s) + "0";
                ++i;
            }
        } else {
            for (Clustering c : ordering) {
                s = this.clusterings.contains(c) ? String.valueOf(s) + "1" : String.valueOf(s) + "0";
            }
        }
        this.signature = s;
    }

    public String getSignature() {
        return this.signature;
    }

    public void addClustering(Clustering clustering) {
        if (this.clusterings == null) {
            this.clusterings = new HashSet<Clustering>();
        }
        this.clusterings.add(clustering);
    }

    public Set<Clustering> getClusterings() {
        return this.clusterings;
    }

    public void addClusterings(Set<Clustering> set) {
        if (this.clusterings == null) {
            this.clusterings = new HashSet<Clustering>();
        }
        this.clusterings.addAll(set);
    }

    public int getCooccurrenceCount() {
        if (this.clusterings != null) {
            return this.clusterings.size();
        }
        return 0;
    }

    public String getNiceHTMLString() {
        if (this.niceString != null) {
            return this.niceString;
        }
        if (this.lastUsedOrdering == null) {
            return null;
        }
        int i = 1;
        int cutoff = 10;
        String s = "<html>(" + this.u.getName() + ", " + this.v.getName() + "): <b>" + this.clusterings.size() + "</b><br>";
        for (Clustering c : this.lastUsedOrdering) {
            if (i >= cutoff) {
                s = String.valueOf(s) + "...and more";
                break;
            }
            s = String.valueOf(s) + c.getName() + ": " + (this.clusterings.contains(c) ? "<b>1</b>" : "0") + "<br>";
            ++i;
        }
        this.niceString = s = String.valueOf(s) + "</html>";
        return s;
    }

    public boolean selfReferential() {
        return this.u.getName().equals(this.v.getName());
    }

    public Clustering getClusteringAt(int i) {
        if (this.lastUsedOrdering != null) {
            return this.lastUsedOrdering.get(i);
        }
        return null;
    }

    @Override
    public int compareTo(Cooccurrence o) {
        int i = this.signature.compareTo(o.signature);
        if (i == 0) {
            i = this.u.compareTo(o.u);
        }
        if (i == 0) {
            i = this.v.compareTo(o.v);
        }
        return i;
    }

    public String toString() {
        return this.signature;
    }
}

