/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.data;

import edu.umd.coral.model.data.BitSymmetricMatrix;
import edu.umd.coral.model.data.Cooccurrence;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.Named;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.model.metrics.Entropy;
import edu.umd.coral.model.metrics.Overlap;
import edu.umd.coral.util.IndexedQuickSort;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clustering
implements Comparable<Clustering>,
Named {
    public static final String MODULE_COUNT = "module count";
    public static final String AVG_DENSITY = "Avg. density";
    public static final String AVG_MODULE_SIZE = "Avg. module size";
    public static final String VERTEX_COUNT = "Vertex count";
    public static final String ENTROPY = "Entropy";
    public static final String OVERLAP = "Overlap";
    private String _name;
    private Map<String, Module> _modules = new TreeMap<String, Module>();
    private Set<Vertex> _vertices = new TreeSet<Vertex>();
    private BitSymmetricMatrix _cooccurenceMatrix;
    private int originalVertexCount;
    private Color color;
    private int originalModuleCount = 0;
    private boolean _hasOverlap = false;

    public Clustering() {
        this._name = UUID.randomUUID().toString();
    }

    public Clustering(String name) {
        this._name = name;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public int size() {
        return this._modules.size();
    }

    public void addModule(Module m) throws Exception {
        Module returned = this._modules.put(m.getName(), m);
        if (returned != null) {
            throw new Exception("Module with this name already exists. Module: " + m.getName() + " in " + this._name);
        }
        Set<Vertex> vSet = m.getVertexMap();
        for (Vertex v : vSet) {
            if (!this._vertices.contains(v)) continue;
            this._hasOverlap = true;
        }
        this._vertices.addAll(vSet);
    }

    public Collection<Module> getModules() {
        return this._modules.values();
    }

    public void addToModule(String moduleName, Vertex v) {
        if (!this._modules.containsKey(moduleName)) {
            System.out.println("No module " + moduleName + ". Skipping " + v);
            return;
        }
        Module m = this._modules.get(moduleName);
        m.addVertex(v);
        boolean alreadyPresent = !this._vertices.add(v);
        this._hasOverlap = this._hasOverlap || alreadyPresent;
    }

    public HashMap<Vertex, TreeMap<Vertex, Cooccurrence>> createCooccurenceMatrix(ArrayList<Vertex> ordering) {
        if (this._vertices == null || this._modules == null) {
            return null;
        }
        int size = this._vertices.size();
        String[] names = new String[ordering.size()];
        int i = 0;
        while (i < size) {
            names[i] = ordering.get(i).getName();
            ++i;
        }
        return this.generateMatrix(size, names);
    }

    public HashMap<Vertex, TreeMap<Vertex, Cooccurrence>> createCooccurenceMatrix() {
        if (this._vertices == null || this._modules == null) {
            return null;
        }
        int size = this._vertices.size();
        Vertex[] sortedVertices = this.getSortedVertexArray();
        String[] names = new String[sortedVertices.length];
        int i = 0;
        while (i < size) {
            names[i] = sortedVertices[i].getName();
            ++i;
        }
        return this.generateMatrix(size, names);
    }

    private HashMap<Vertex, TreeMap<Vertex, Cooccurrence>> generateMatrix(int size, String[] names) {
        HashMap<Vertex, TreeMap<Vertex, Cooccurrence>> hashMap = new HashMap<Vertex, TreeMap<Vertex, Cooccurrence>>();
        Object[] sortedNames = (String[])names.clone();
        int[] indices = new int[size];
        int i = 0;
        while (i < size) {
            indices[i] = i;
            ++i;
        }
        IndexedQuickSort.quicksort((String[])sortedNames, indices);
        BitSymmetricMatrix matrix = new BitSymmetricMatrix(size, names);
        boolean in = false;
        for (Module m : this._modules.values()) {
            if (m.getName().equals("__misc__")) continue;
            int moduleSize = m.getSize();
            ArrayList<Vertex> vertices = new ArrayList<Vertex>(m.getVertexMap());
            i = 0;
            while (i < moduleSize - 1) {
                Vertex u = vertices.get(i);
                int j = i + 1;
                while (j < moduleSize) {
                    Vertex v = vertices.get(j);
                    int u_i = indices[Arrays.binarySearch(sortedNames, u.getName())];
                    int v_i = indices[Arrays.binarySearch(sortedNames, v.getName())];
                    matrix.setElement(u_i, v_i, 1, in);
                    matrix.setElement(v_i, u_i, 1, in);
                    Cooccurrence cooccur = new Cooccurrence(u, v);
                    cooccur.addClustering(this);
                    TreeMap<Vertex, Cooccurrence> set = hashMap.get(u);
                    if (set == null) {
                        set = new TreeMap();
                        hashMap.put(u, set);
                    }
                    set.put(v, cooccur);
                    ++j;
                }
                ++i;
            }
        }
        this._cooccurenceMatrix = matrix;
        return hashMap;
    }

    public BitSymmetricMatrix getCoocurenceMatrix() {
        return this._cooccurenceMatrix;
    }

    public String toString() {
        return this._name;
    }

    public boolean hasVertex(Vertex v) {
        return this._vertices.contains(v);
    }

    public Vertex[] getSortedVertexArray() {
        Object[] array = new Vertex[this._vertices.size()];
        int index = 0;
        for (Vertex v : this._vertices) {
            array[index++] = v;
        }
        Arrays.sort(array);
        return array;
    }

    @Override
    public int compareTo(Clustering c) {
        if (c == null) {
            return 1;
        }
        if (this._name == null) {
            if (c._name == null) {
                return 0;
            }
            return -1;
        }
        return this._name.compareTo(c._name);
    }

    public Module getModule(String name) {
        if (this._modules == null) {
            return null;
        }
        return this._modules.get(name);
    }

    public Vertex[] getVertices() {
        return this._vertices.toArray(new Vertex[0]);
    }

    public int getVertexCount() {
        return this._vertices.size();
    }

    public int getModuleCount() {
        if (this.originalModuleCount == 0) {
            return this._modules.size();
        }
        return this.originalModuleCount;
    }

    public float getAverageDensity(boolean includeGrabBag) {
        float sum = 0.0f;
        for (Module m : this._modules.values()) {
            if (!includeGrabBag && m.getName().equals("__misc__")) continue;
            int edgeCount = m.getEdgeCount();
            float expectedEdgeCount = m.getExpectedEdgeCount();
            if (expectedEdgeCount == 0.0f) continue;
            sum += (float)edgeCount / expectedEdgeCount;
        }
        return sum;
    }

    public float getAverageModuleSize(boolean includeGrabBag) {
        int mod_count = 0;
        int vert_cnt = 0;
        for (Module m : this._modules.values()) {
            if (!includeGrabBag && m.getName().equals("__misc__")) continue;
            ++mod_count;
            vert_cnt += m.getSize();
        }
        if (mod_count == 0) {
            return 0.0f;
        }
        return (float)vert_cnt * 1.0f / (float)mod_count;
    }

    public Float getValue(String value, boolean includeGrabBag) {
        Float count = Float.valueOf(0.0f);
        if (value.equals(MODULE_COUNT)) {
            count = Float.valueOf(this.getModuleCount());
        } else if (value.equals(AVG_DENSITY)) {
            count = Float.valueOf(this.getAverageDensity(includeGrabBag));
        } else if (value.equals(AVG_MODULE_SIZE)) {
            count = Float.valueOf(this.getAverageModuleSize(includeGrabBag));
        } else if (value.equals(VERTEX_COUNT)) {
            count = Float.valueOf(this.getOriginalVertexCount());
        } else if (value.equals(OVERLAP)) {
            count = Float.valueOf(Overlap.getOverlap(this, includeGrabBag));
        } else if (value.equals(ENTROPY)) {
            count = Float.valueOf(Entropy.getEntropy(this, includeGrabBag));
        }
        return count;
    }

    public void setOriginalVertexCount(int vertexCount) {
        this.originalVertexCount = vertexCount;
    }

    public int getOriginalVertexCount() {
        return this.originalVertexCount;
    }

    public boolean containsVertex(Vertex v) {
        return this._vertices.contains(v);
    }

    public Set<Collection<Vertex>> getCollections() {
        HashSet<Collection<Vertex>> set = new HashSet<Collection<Vertex>>();
        Collection<Module> col = this.getModules();
        for (Module m : col) {
            set.add(m.getVertices());
        }
        return set;
    }

    public Collection<Module> getVertexModule(Vertex v) {
        ArrayList<Module> array = new ArrayList<Module>();
        for (Module m : this._modules.values()) {
            if (!m.contains(v)) continue;
            array.add(m);
        }
        return array;
    }

    public void recordOriginalModuleCount() {
        this.originalModuleCount = this._modules.size();
    }

    public boolean hasModule(String moduleName) {
        if (this._modules == null) {
            return false;
        }
        return this._modules.containsKey(moduleName);
    }

    public Vertex getVertex(String vName) {
        for (Vertex u : this._vertices) {
            if (!u.getName().equals(vName)) continue;
            return u;
        }
        return null;
    }

    public void clear() {
        this._cooccurenceMatrix = null;
        this._modules.clear();
        this._vertices.clear();
    }

    public boolean hasOverlap() {
        return this._hasOverlap;
    }
}

