/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.data;

import edu.umd.coral.model.data.Matrix;

public class BitSymmetricMatrix
extends Matrix {
    long[] bitVectors;
    private int N;
    private final int LEN = 63;

    public BitSymmetricMatrix(int N, String[] names) {
        this.row_count = this.column_count = N;
        this.N = N;
        this.columnNames = names;
        this.rowNames = names;
        int numVectors = (int)Math.ceil((double)(N * (N + 1)) * 1.0 / 126.0);
        if (numVectors == 0) {
            numVectors = 1;
        }
        this.bitVectors = new long[numVectors];
    }

    public int getVectorCount() {
        if (this.bitVectors == null) {
            return 0;
        }
        return this.bitVectors.length;
    }

    public double getMax() {
        long res = 0L;
        int i = 0;
        while (i < this.bitVectors.length) {
            res |= this.bitVectors[i];
            ++i;
        }
        return res > 0L ? 1 : 0;
    }

    public double getElement(int i, int j) {
        if (i > j) {
            int temp = i;
            i = j;
            j = temp;
        }
        int index = this.getIndex(i, j);
        int vectorIndex = index / 63;
        int remainder = 63 - (index - vectorIndex * 63) - 1;
        assert (remainder < 63);
        long intermediate = this.bitVectors[vectorIndex] >>> remainder & 1L;
        return intermediate;
    }

    private int getIndex(int i, int j) {
        return (2 * this.N - i + 1) * i / 2 + (j - i);
    }

    public void setElement(int i, int j, int value, boolean inGrabBag) {
        assert (value == 0 || value == 1);
        if (i > j) {
            int temp = i;
            i = j;
            j = temp;
        }
        long index = this.getIndex(i, j);
        long vectorIndex = index / 63L;
        long remainder = 63L - (index - vectorIndex * 63L) - 1L;
        long one = 1L;
        long mask = 0L;
        if (value == 0) {
            mask = one << (int)remainder ^ 0xFFFFFFFFFFFFFFFFL;
            this.bitVectors[(int)vectorIndex] = this.bitVectors[(int)vectorIndex] & mask;
        } else {
            mask = one << (int)remainder;
            this.bitVectors[(int)vectorIndex] = this.bitVectors[(int)vectorIndex] | mask;
        }
    }

    public void setElement(String row, String column, int value) {
        int i = 0;
        int j = 0;
        boolean foundRow = false;
        boolean foundCol = false;
        int k = 0;
        while (!(k >= this.rowNames.length || foundRow && foundCol)) {
            if (this.rowNames[k].equals(row)) {
                i = k;
            }
            if (this.rowNames[k].equals(column)) {
                j = k;
            }
            ++k;
        }
        this.setElement(i, j, value);
    }

    public Matrix addMatrix(BitSymmetricMatrix m) {
        Matrix bsm = new Matrix();
        return bsm;
    }

    public Matrix subtractMatrix(BitSymmetricMatrix m) {
        Matrix bsm = new Matrix();
        return bsm;
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.bitVectors.length) {
            s = String.valueOf(s) + BitSymmetricMatrix.printBits(this.bitVectors[i]);
            ++i;
        }
        int lastIndex = 0;
        String out = "";
        i = 0;
        while (i < this.N) {
            out = String.valueOf(out) + s.substring(lastIndex, lastIndex + this.N) + "\n";
            lastIndex += this.N;
            ++i;
        }
        return out;
    }

    public static String printBits(long l) {
        String s = "";
        int i = 0;
        while (i < 63) {
            long t = l >>> i & 1L;
            s = String.valueOf(String.valueOf(t)) + s;
            ++i;
        }
        return s;
    }

    public static float jaccard(BitSymmetricMatrix A, BitSymmetricMatrix B, boolean includeGB) {
        int j;
        long sum;
        assert (A.N == B.N);
        int a = 0;
        int bc = 0;
        int i = 0;
        while (i < A.bitVectors.length) {
            sum = A.bitVectors[i] & B.bitVectors[i];
            j = 0;
            while (j < 63) {
                a = (int)((long)a + (sum >>> j & 1L));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < A.bitVectors.length) {
            sum = A.bitVectors[i] ^ B.bitVectors[i];
            j = 0;
            while (j < 63) {
                bc = (int)((long)bc + (sum >>> j & 1L));
                ++j;
            }
            ++i;
        }
        return (float)a * 1.0f / (float)(a + bc);
    }

    public static float mirkin(BitSymmetricMatrix A, BitSymmetricMatrix B, boolean includeGB) {
        assert (A.N == B.N);
        int bc = 0;
        int i = 0;
        while (i < A.bitVectors.length) {
            long sum = A.bitVectors[i] ^ B.bitVectors[i];
            int j = 0;
            while (j < 63) {
                bc = (int)((long)bc + (sum >>> j & 1L));
                ++j;
            }
            ++i;
        }
        return 1.0f * (float)bc / (float)(A.column_count * A.row_count);
    }

    public static float rand(BitSymmetricMatrix A, BitSymmetricMatrix B, boolean includeGB) {
        int j;
        long sum;
        assert (A.N == B.N);
        int a = 0;
        int d = 0;
        int i = 0;
        while (i < A.bitVectors.length) {
            sum = A.bitVectors[i] & B.bitVectors[i];
            j = 0;
            while (j < 63) {
                a = (int)((long)a + (sum >>> j & 1L));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < A.bitVectors.length) {
            sum = A.bitVectors[i] & B.bitVectors[i];
            sum ^= 0xFFFFFFFFFFFFFFFFL;
            j = 0;
            while (j < 63) {
                d = (int)((long)d + (sum >>> j & 1L));
                ++j;
            }
            ++i;
        }
        return (float)(a + d) * 1.0f / (float)(A.column_count * B.column_count);
    }

    public static float fm(BitSymmetricMatrix A, BitSymmetricMatrix B, boolean includeGB) {
        int j;
        long sum;
        assert (A.N == B.N);
        int a = 0;
        int b = 0;
        int c = 0;
        int i = 0;
        while (i < A.bitVectors.length) {
            sum = A.bitVectors[i] & B.bitVectors[i];
            j = 0;
            while (j < 63) {
                a = (int)((long)a + (sum >>> j & 1L));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < A.bitVectors.length) {
            sum = A.bitVectors[i];
            j = 0;
            while (j < 63) {
                b = (int)((long)b + (sum >>> j & 1L));
                ++j;
            }
            ++i;
        }
        b /= 2;
        i = 0;
        while (i < A.bitVectors.length) {
            sum = A.bitVectors[i];
            j = 0;
            while (j < 63) {
                c = (int)((long)c + (sum >>> j & 1L));
                ++j;
            }
            ++i;
        }
        return (float)Math.sqrt((float)(a * a) * 1.0f / (float)(a + b) / (float)(a + (c /= 2)));
    }

    public static BitSymmetricMatrix filter(BitSymmetricMatrix base, BitSymmetricMatrix toFilter) {
        BitSymmetricMatrix filtered = new BitSymmetricMatrix(toFilter.column_count, toFilter.columnNames);
        int i = 0;
        while (i < toFilter.bitVectors.length) {
            filtered.bitVectors[i] = base.bitVectors[i] & toFilter.bitVectors[i];
            ++i;
        }
        return filtered;
    }
}

