/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.data;

import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.MyMTJMatrix;
import java.util.Iterator;
import no.uib.cipr.matrix.MatrixEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseMatrix
extends Matrix {
    private MyMTJMatrix data;
    private MyMTJMatrix isInBase;

    public BaseMatrix(MyMTJMatrix data, MyMTJMatrix base) throws Exception {
        super(data.rowNames, data.columnNames);
        int i = 0;
        while (i < data.getColumnCount()) {
            if (!data.getRowName(i).equals(base.getRowName(i))) {
                throw new Exception("matrix order should be the same");
            }
            ++i;
        }
        this.setMax(data.getMax());
        this.data = data;
        this.isInBase = base;
    }

    @Override
    public double getElement(int i, int j) {
        return this.data.getElement(i, j);
    }

    public Iterator<MatrixEntry> iterator() {
        return this.data.getMatrix().iterator();
    }

    public boolean isBase(int i, int j) {
        return this.isInBase.getElement(i, j) > 0.0;
    }

    public Matrix getDataMatrix() {
        return this.data;
    }

    public Matrix getBaseMatrix() {
        return this.isInBase;
    }
}

