/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.managers;

import edu.umd.coral.managers.Manager;
import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Matrix;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class MatrixManager
extends Manager {
    private static final String MATRIX_NAME = "co_occurr_matrix";
    private static final String NODE_FILE_NAME = "node_list";
    public static final int SAVE_AS_MATRIX = 1;
    public static final int SAVE_AS_ADJACENCY_LIST = 2;
    private File directory;
    private String delimiter;
    private int mode;

    public MatrixManager(DataModel dataModel, File directory, String d, int mode) {
        super(dataModel);
        this.directory = directory;
        this.delimiter = d;
        this.mode = mode;
    }

    public void execute() {
        if (this.getModel().getCurrentMatrix() == null) {
            System.out.println("Save matrix: matrix is null");
            return;
        }
        if ((this.mode & 1) > 0) {
            this.saveAsMatrix();
        }
        if ((this.mode & 2) >> 1 > 0) {
            this.saveAsAdjacencyList();
        }
    }

    private void saveAsAdjacencyList() {
        try {
            String path = this.directory.getCanonicalPath();
            Matrix currentMatrix = this.getModel().getCurrentMatrix();
            this.saveNodesNames(currentMatrix.columnNames, this.delimiter, path);
            Calendar time = Calendar.getInstance();
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
            String label = format.format(time.getTime());
            BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(path) + File.separator + MATRIX_NAME + "_" + label + ".csv"));
            currentMatrix.saveToFileAsAdjacencyList(out, this.delimiter);
            System.out.println("Done: coccurrence matrix save to " + path + File.separator + MATRIX_NAME + "_" + label + ".csv");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveNodesNames(String[] columnNames, String d, String path) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(path) + File.separator + NODE_FILE_NAME + ".txt"));
            int i = 0;
            String[] stringArray = columnNames;
            int n = columnNames.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                out.write(String.valueOf(i));
                out.write(d);
                out.write(s);
                out.write("\n");
                ++i;
                ++n2;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveAsMatrix() {
        try {
            String path = this.directory.getCanonicalPath();
            BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(path) + File.separator + MATRIX_NAME + ".txt"));
            Matrix currentMatrix = this.getModel().getCurrentMatrix();
            currentMatrix.saveToFileAsCSVMatrix(out, this.delimiter);
            System.out.println("Done: coccurrence matrix save to " + path + File.separator + MATRIX_NAME + ".txt");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

