/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.managers;

import edu.umd.coral.managers.Manager;
import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LooseCliqueFinder
extends Manager {
    public LooseCliqueFinder(DataModel m) {
        super(m);
    }

    @Override
    public void execute() {
        DataModel m = this.getModel();
        Matrix matrix = m.getCurrentMatrix();
        Stack<Vertex> stack = this.getVertices(matrix);
        Set<Collection<Vertex>> cliques = this.findLooseCliques(stack, matrix.getMax() - 1.0);
        System.out.println(cliques);
    }

    private Set<Collection<Vertex>> findLooseCliques(Stack<Vertex> vertices, double minEdgeWeight) {
        HashSet<Collection<Vertex>> set = new HashSet<Collection<Vertex>>();
        HashSet<Vertex> toExpand = new HashSet<Vertex>();
        while (vertices.size() > 0) {
            Vertex u = vertices.pop();
            Collection<Vertex> neighbors = u.getNeighbors();
            ArrayList<Vertex> cluster = new ArrayList<Vertex>();
            for (Vertex v : neighbors) {
                if (toExpand.contains(v) || !(u.getEdgeWeight(v) >= minEdgeWeight)) continue;
                toExpand.add(v);
                cluster.add(v);
                vertices.remove(v);
            }
            set.add(cluster);
        }
        return set;
    }

    private Stack<Vertex> getVertices(Matrix m) {
        Stack<Vertex> stack = new Stack<Vertex>();
        Vertex[] vertices = new Vertex[m.getColumnCount()];
        int length = m.getColumnCount();
        int i = 0;
        while (i < length) {
            vertices[i] = new Vertex(m.columnNames[i]);
            stack.push(vertices[i]);
            ++i;
        }
        double[][] data = m.getData();
        i = 0;
        while (i < length) {
            int j = i;
            while (j < length) {
                if (data[i][j] > 0.0) {
                    vertices[i].addNeighbor(vertices[j], data[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return stack;
    }
}

