/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.managers;

import edu.umd.coral.managers.CliqueManager;
import edu.umd.coral.model.data.BaseMatrix;
import edu.umd.coral.model.data.Clique;
import edu.umd.coral.model.data.Matrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastDenseSubgraphFinder
implements CliqueManager {
    @Override
    public ArrayList<Clique> getCliques(Matrix m, boolean cutoff) {
        double sum = 0.0;
        int n = m.getColumnCount();
        int z = 0;
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                sum += m.getElement(i, j);
                if (m.getElement(i, j) != 0.0) {
                    ++z;
                }
                ++j;
            }
            ++i;
        }
        double avg_edge_weight = sum / (double)z;
        double[][] sums = m instanceof BaseMatrix ? this.getSumsFlexMatrix(((BaseMatrix)m).getBaseMatrix()) : this.getSumsMatrix(m.getData());
        Set<Integer> vertex_indices = this.findMaxDensity(sums);
        ArrayList<Integer> blah = new ArrayList<Integer>(vertex_indices);
        Collections.sort(blah);
        ArrayList<Clique> cliques = this.constructCliques(vertex_indices, sums, avg_edge_weight, true, n);
        return cliques;
    }

    private double[][] getSumsFlexMatrix(Matrix matrix) {
        int n = matrix.getColumnCount();
        double[][] sums = new double[n][n];
        int i = 0;
        while (i < n) {
            sums[i][i] = 0.0;
            ++i;
        }
        i = 1;
        while (i < n) {
            double[] column_sums = new double[i + 1];
            column_sums[i] = 0.0;
            int j = i - 1;
            while (j >= 0) {
                column_sums[j] = column_sums[j + 1] + matrix.getElement(j, i);
                sums[j][i] = sums[j][i - 1] + column_sums[j];
                --j;
            }
            ++i;
        }
        return sums;
    }

    public double[][] getSumsMatrix(double[][] M) {
        int n = M.length;
        double[][] sums = new double[n][n];
        int i = 0;
        while (i < n) {
            sums[i][i] = 0.0;
            ++i;
        }
        i = 1;
        while (i < n) {
            double[] column_sums = new double[i + 1];
            column_sums[i] = 0.0;
            int j = i - 1;
            while (j >= 0) {
                column_sums[j] = column_sums[j + 1] + M[j][i];
                sums[j][i] = sums[j][i - 1] + column_sums[j];
                --j;
            }
            ++i;
        }
        return sums;
    }

    public Set<Integer> findMaxDensity(double[][] density) {
        int j;
        HashSet<Integer> vertex_indices = new HashSet<Integer>();
        int n = density.length;
        double[] d_opt = new double[n];
        int[] arrows = new int[n];
        int i = 0;
        while (i < n) {
            d_opt[i] = density[i][i];
            ++i;
        }
        arrows[0] = -1;
        i = 1;
        while (i < n) {
            d_opt[i] = density[0][i] / (double)(i + 1);
            arrows[i] = -1;
            j = 1;
            while (j < i) {
                double s = d_opt[j] + density[j + 1][i] / (double)(i - j);
                if (s > d_opt[i]) {
                    d_opt[i] = s;
                    arrows[i] = j;
                }
                ++j;
            }
            ++i;
        }
        vertex_indices.add(n - 1);
        j = arrows[n - 1];
        while (j > 0) {
            vertex_indices.add(j);
            j = arrows[j];
        }
        return vertex_indices;
    }

    public ArrayList<Clique> constructCliques(Set<Integer> set, double[][] sums, double weight, boolean do_cutoff, int n) {
        ArrayList<Integer> list = new ArrayList<Integer>(set);
        Collections.sort(list);
        ArrayList<Clique> cliques = new ArrayList<Clique>();
        int prevIndex = 0;
        int i = 0;
        while (i < set.size()) {
            int h_pq;
            double avg_density;
            int size;
            int currentIndex = list.get(i);
            double s_pq = sums[prevIndex][currentIndex];
            double clique_density = s_pq / (double)(size = currentIndex - prevIndex + 1);
            if (clique_density > (avg_density = (double)((h_pq = currentIndex - prevIndex + 1) - 1) * s_pq / (double)((n - 1) * (n - 2))) || !do_cutoff) {
                Clique cliq = new Clique();
                cliq.setQualityValue(clique_density);
                int j = prevIndex;
                while (j <= currentIndex) {
                    cliq.addIndex(j);
                    ++j;
                }
                cliques.add(cliq);
            }
            prevIndex = currentIndex + 1;
            ++i;
        }
        System.out.println("Total cliques: " + list.size() + ", after filtering: " + cliques.size());
        return cliques;
    }
}

