/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.managers;

import edu.umd.coral.managers.CliqueManager;
import edu.umd.coral.model.data.Clique;
import edu.umd.coral.model.data.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseSubgraphFinder
implements CliqueManager {
    @Override
    public ArrayList<Clique> getCliques(Matrix m, boolean cutoff) {
        HashMap<Integer, Integer> histogram = new HashMap<Integer, Integer>();
        double sum = 0.0;
        int count = 0;
        int size = m.getColumnCount();
        int i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                double value = m.getElement(i, j);
                if (value > 0.0) {
                    ++count;
                    sum += value;
                }
                if (histogram.containsKey((int)value)) {
                    int h = (Integer)histogram.get((int)value);
                    histogram.put((int)value, h + 1);
                } else {
                    histogram.put((int)value, 1);
                }
                ++j;
            }
            ++i;
        }
        double avg_edge_weight = sum / (double)count;
        double[][] density = this.getDensityMatrix(m.getData());
        Set<Integer> vertex_indices = this.findMaxDensity(density);
        ArrayList<Integer> blah = new ArrayList<Integer>(vertex_indices);
        Collections.sort(blah);
        ArrayList<Clique> cliques = this.constructCliques(vertex_indices, m, density, avg_edge_weight, true);
        return cliques;
    }

    public double[][] getDensityMatrix(double[][] M) {
        int n = M.length;
        double[][] density = new double[n][n];
        int s = 2;
        while (s < n + 1) {
            int i = 0;
            while (i < n - s + 1) {
                int k = i + s;
                double new_sum = 0.0;
                int j = i;
                while (j < k - 1) {
                    new_sum += M[j][k - 1];
                    ++j;
                }
                double old_sum = density[i][k - 2] * (double)(s - 1);
                density[i][k - 1] = (old_sum + new_sum) / (double)s;
                ++i;
            }
            ++s;
        }
        return density;
    }

    public Set<Integer> findMaxDensity(double[][] density) {
        int n = density.length;
        double[] d_opt = new double[n];
        HashSet<Integer> vertex_indices = new HashSet<Integer>();
        Arrays.fill(d_opt, -1.0);
        d_opt[0] = 0.0;
        int i = 1;
        while (i < n) {
            d_opt[i] = this.getDense(i, d_opt, density, vertex_indices);
            ++i;
        }
        return vertex_indices;
    }

    public double getDense(int k, double[] d_opt, double[][] density, Set<Integer> vertexIndices) {
        if (k <= 0) {
            return 0.0;
        }
        ArrayList<Pair> dtk = new ArrayList<Pair>();
        int t = 0;
        while (t < k + 1) {
            double d2 = t > 0 && d_opt[t - 1] != 1.0 ? d_opt[t - 1] : this.getDense(t - 1, d_opt, density, vertexIndices);
            Pair p = new Pair(t, density[t][k] + d2);
            dtk.add(p);
            ++t;
        }
        Pair maxPair = (Pair)Collections.max(dtk);
        vertexIndices.add(maxPair.t);
        return maxPair.density;
    }

    public ArrayList<Clique> constructCliques(Set<Integer> set, Matrix m, double[][] density, double avg_edge_weight, boolean do_cutoff) {
        int size;
        Clique cliq;
        double clique_density;
        int currentIndex;
        ArrayList<Integer> list = new ArrayList<Integer>(set);
        Collections.sort(list);
        if (m == null) {
            return null;
        }
        ArrayList<Clique> cliques = new ArrayList<Clique>();
        int prevIndex = list.get(0);
        int i = 1;
        while (i < set.size()) {
            int size2;
            currentIndex = list.get(i);
            clique_density = density[prevIndex][currentIndex];
            if (clique_density > avg_edge_weight * (double)(size2 = currentIndex - prevIndex) / 2.0 || !do_cutoff) {
                cliq = new Clique();
                cliq.setQualityValue(clique_density);
                int j = prevIndex;
                while (j < currentIndex) {
                    cliq.addIndex(j);
                    ++j;
                }
                cliques.add(cliq);
            }
            prevIndex = currentIndex;
            ++i;
        }
        currentIndex = m.getColumnCount() - 1;
        clique_density = density[prevIndex][currentIndex];
        if (clique_density > avg_edge_weight * (double)(size = currentIndex - prevIndex) / 2.0 || !do_cutoff) {
            cliq = new Clique();
            cliq.setQualityValue(clique_density);
            int j = prevIndex;
            while (j < currentIndex) {
                cliq.addIndex(j);
                ++j;
            }
            cliques.add(cliq);
        }
        return cliques;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Pair
    implements Comparable<Pair> {
        public int t;
        public double density;

        public Pair(int t, double d) {
            this.t = t;
            this.density = d;
        }

        @Override
        public int compareTo(Pair a) {
            if (this.density < a.density) {
                return -1;
            }
            if (this.density > a.density) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.t)) + ": " + String.valueOf(this.density);
        }
    }
}

