/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.managers;

import edu.umd.coral.managers.FileParserProgressDialog;
import edu.umd.coral.managers.IManager;
import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.parse.VertexFileParser;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ClusteringsManager
implements IManager {
    private DataModel _dataModel;
    private File[] moduleFiles;
    private File vertexFile;

    public ClusteringsManager(DataModel model, File[] files) {
        this._dataModel = model;
        boolean areClusterFiles = this.checkType(files);
        if (files.length == 1 && !areClusterFiles) {
            this.vertexFile = files[0];
        } else {
            this.moduleFiles = files;
        }
    }

    private boolean checkType(File[] files) {
        boolean areClusterFiles = true;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                InputStreamReader fis = new InputStreamReader(new FileInputStream(f));
                BufferedReader br = new BufferedReader(fis);
                String header = br.readLine();
                if (header != null) {
                    header = header.trim().toLowerCase();
                    areClusterFiles = areClusterFiles && header.toLowerCase().startsWith("c");
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not open an input file " + f.getName());
                e.printStackTrace();
            }
            catch (IOException e) {
                System.out.println("Could not read from an input file " + f.getName());
                e.printStackTrace();
            }
            ++n2;
        }
        return areClusterFiles;
    }

    public void execute() {
        if (this.vertexFile != null) {
            this.loadVertexFile();
        } else if (this.moduleFiles != null) {
            this.loadClusteringFiles();
        }
    }

    private void loadClusteringFiles() {
        System.out.println("Parsing clustering files");
        try {
            String[] fileNames = new String[this.moduleFiles.length];
            int i = 0;
            while (i < fileNames.length) {
                fileNames[i] = this.moduleFiles[i].getCanonicalPath();
                ++i;
            }
            FileParserProgressDialog dialog = new FileParserProgressDialog(this._dataModel, fileNames);
            dialog.pack();
            JFrame frame = this._dataModel.getMainWindow();
            Point p = frame.getLocationOnScreen();
            Rectangle r = frame.getBounds();
            Dimension d = dialog.getPreferredSize();
            int x = p.x + (int)Math.floor(((double)r.width - d.getWidth()) / 2.0);
            int y = p.y + (int)Math.floor(((double)r.height - d.getHeight()) / 2.0);
            dialog.setLocation(x, y);
            dialog.setVisible(true);
            System.out.println("Loaded " + this.moduleFiles.length + " clustering files");
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Data loading error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Data loading error", 0);
        }
    }

    private void loadVertexFile() {
        try {
            String fileName = this.vertexFile.getCanonicalPath();
            VertexFileParser parser = new VertexFileParser();
            this._dataModel.reset();
            parser.parse(fileName, this._dataModel);
            System.out.println("Loaded vertex file");
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Data loading error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Data loading error", 0);
        }
    }
}

