/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.clustering;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import edu.umd.coral.clustering.MatrixReordering;

public class SpectralReordering
implements MatrixReordering {
    private long startMillis;

    public edu.umd.coral.model.data.Matrix reorder(edu.umd.coral.model.data.Matrix originalMatrix) {
        System.out.println("reordering sum of matrices");
        this.startMillis = System.currentTimeMillis();
        System.out.println("current time: " + (System.currentTimeMillis() - this.startMillis));
        edu.umd.coral.model.data.Matrix[] components = edu.umd.coral.model.data.Matrix.getConnectedComponents(originalMatrix);
        System.out.println("found connected components " + components.length);
        System.out.println("current time: " + (System.currentTimeMillis() - this.startMillis));
        int size = components.length;
        edu.umd.coral.model.data.Matrix[] reorderedComponents = new edu.umd.coral.model.data.Matrix[size];
        int i = 0;
        edu.umd.coral.model.data.Matrix[] matrixArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            edu.umd.coral.model.data.Matrix m = matrixArray[n2];
            reorderedComponents[i] = this.reorderConnectedMatrix(m);
            ++i;
            ++n2;
        }
        System.out.println("reordered connected components ");
        System.out.println("current time: " + (System.currentTimeMillis() - this.startMillis));
        edu.umd.coral.model.data.Matrix matrix = edu.umd.coral.model.data.Matrix.mergeComponents(reorderedComponents, originalMatrix.getMax());
        System.out.println("merged components ");
        System.out.println("current time: " + (System.currentTimeMillis() - this.startMillis));
        long endMillies = System.currentTimeMillis();
        System.out.println("total time to reorder: " + (endMillies - this.startMillis));
        return matrix;
    }

    private edu.umd.coral.model.data.Matrix reorderConnectedMatrix(edu.umd.coral.model.data.Matrix originalMatrix) {
        Matrix laplacian = originalMatrix.getLaplacianMatrix();
        System.out.println("got laplacian, N=" + originalMatrix.getColumnCount());
        System.out.println("current time: " + (System.currentTimeMillis() - this.startMillis));
        EigenvalueDecomposition evd = laplacian.eig();
        System.out.println("computed EVD");
        System.out.println("current time: " + (System.currentTimeMillis() - this.startMillis));
        Matrix diagonal = evd.getD();
        System.out.println("got eigenvalues ");
        System.out.println("current time: " + (System.currentTimeMillis() - this.startMillis));
        int secondIndex = -1;
        int size = originalMatrix.getRowCount();
        secondIndex = this.getSecondSmallestEigenValueIndex(diagonal);
        Matrix eigenVectors = evd.getV();
        System.out.println("got eigenvector ");
        System.out.println("current time: " + (System.currentTimeMillis() - this.startMillis));
        if (secondIndex >= 0) {
            int j;
            Matrix ev2 = eigenVectors.getMatrix(0, size - 1, secondIndex, secondIndex);
            int[] ranks = new int[size];
            int i = 0;
            while (i < size) {
                ranks[i] = i;
                ++i;
            }
            i = 0;
            while (i < size) {
                j = 0;
                while (j < size - i - 1) {
                    double value2;
                    double value1 = ev2.get(ranks[j], 0);
                    if (value1 > (value2 = ev2.get(ranks[j + 1], 0))) {
                        int tempIndex = ranks[j];
                        ranks[j] = ranks[j + 1];
                        ranks[j + 1] = tempIndex;
                    }
                    ++j;
                }
                ++i;
            }
            int[] ranks_prime = new int[size];
            i = 0;
            while (i < size) {
                ranks_prime[ranks[i]] = i;
                ++i;
            }
            ranks = ranks_prime;
            System.out.println("ranked by eigenvector ");
            System.out.println("current time: " + (System.currentTimeMillis() - this.startMillis));
            String[] names = new String[size];
            double[][] data = new double[size][size];
            i = 0;
            while (i < size) {
                int oldRowIndex = ranks[i];
                names[oldRowIndex] = originalMatrix.getRowName(i);
                j = 0;
                while (j < size) {
                    int oldColumnIndex = ranks[j];
                    data[oldRowIndex][oldColumnIndex] = originalMatrix.getElement(i, j);
                    ++j;
                }
                ++i;
            }
            edu.umd.coral.model.data.Matrix m = new edu.umd.coral.model.data.Matrix(data, names, names, originalMatrix.getMax());
            System.out.println("reordered matrix ");
            System.out.println("current time: " + (System.currentTimeMillis() - this.startMillis));
            return m;
        }
        return originalMatrix;
    }

    private int getSecondSmallestEigenValueIndex(Matrix diagonal) {
        double value;
        int size = diagonal.getColumnDimension();
        int secondIndex = -1;
        double secondSmallestEigenValue = Double.MAX_VALUE;
        double smallestEigenValue = diagonal.get(0, 0);
        int i = 0;
        while (i < size) {
            value = diagonal.get(i, i);
            if (value < smallestEigenValue) {
                smallestEigenValue = value;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            value = diagonal.get(i, i);
            if (value > smallestEigenValue && value < secondSmallestEigenValue) {
                secondSmallestEigenValue = value;
                secondIndex = i;
            }
            ++i;
        }
        return secondIndex;
    }
}

