/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.ui.CoralMenu;
import edu.umd.coral.ui.dialog.SelectClusteringOrderDialog;
import edu.umd.coral.ui.dialog.action.SaveFigureAction;
import edu.umd.coral.ui.panel.LadderPanel;
import edu.umd.coral.ui.panel.MatrixPanel;
import edu.umd.coral.ui.panel.Vertex2VertexPanel;
import edu.umd.coral.ui.tabs.Module2ModulePanel;
import edu.umd.coral.ui.tabs.OverviewTab;
import edu.umd.coral.ui.tabs.ParallelSetsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.WindowBar;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.properties.WindowTabButtonProperties;
import net.infonode.docking.theme.DockingWindowsTheme;
import net.infonode.docking.theme.ShapedGradientDockingTheme;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.MixedViewHandler;
import net.infonode.docking.util.PropertiesUtil;
import net.infonode.docking.util.ViewMap;
import net.infonode.gui.laf.InfoNodeLookAndFeel;
import net.infonode.util.Direction;

public class JSwingCoral {
    public static final String APP_NAME = "Coral";
    public static final String APP_ICON = "resources/coralicon.png";
    public static final String APP_CONFIG_FILE = "window_config.xml";
    public static final String overviewID = "Statistics";
    public static final String parSetsID = "Parallel partitions";
    public static final String matrixID = "Co-cluster matrix";
    public static final String vertexID = "Item pairs";
    public static final String compareClustID = "Clustering comparison";
    public static final String clustDetailsID = "Module pairs";
    private Icon BUTTON_ICON;
    private RootWindow rootWindow;
    private View[] views = new View[6];
    private ViewMap viewMap = new ViewMap();
    private DockingWindowsTheme currentTheme = new ShapedGradientDockingTheme();
    private RootWindowProperties properties = new RootWindowProperties();
    private JFrame frame = new JFrame("Coral");
    private CoralMenu menu;

    public JSwingCoral() {
        File f = new File("temp.txt");
        String canonical = "";
        try {
            canonical = f.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String parent = canonical.substring(0, canonical.indexOf("temp.txt"));
        String iconPath = String.valueOf(parent) + "resources" + File.separator + "chart_bar.png";
        this.BUTTON_ICON = new ImageIcon(iconPath, "Save figure");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SelectClusteringOrderDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SelectClusteringOrderDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SelectClusteringOrderDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SelectClusteringOrderDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.frame.setDefaultCloseOperation(3);
        this.frame.setSize(1100, 700);
        this.frame.setPreferredSize(new Dimension(1100, 700));
        ImageIcon icon = new ImageIcon(APP_ICON);
        this.frame.setIconImage(icon.getImage());
        DataModel dataModel = new DataModel(this.frame);
        this.createRootWindow(dataModel);
        this.setDefaultLayout(dataModel);
        this.showFrame(dataModel);
    }

    private void createRootWindow(DataModel dataModel) {
        MatrixPanel matrixPanel = new MatrixPanel(dataModel);
        this.views[0] = new View(matrixID, null, (Component)matrixPanel);
        this.viewMap.addView(0, this.views[0]);
        Vertex2VertexPanel v2vPanel = new Vertex2VertexPanel(dataModel);
        this.views[1] = new View(vertexID, null, (Component)v2vPanel);
        this.viewMap.addView(1, this.views[1]);
        ParallelSetsPanel ppp = new ParallelSetsPanel(dataModel);
        this.views[2] = new View(parSetsID, null, (Component)ppp);
        this.viewMap.addView(2, this.views[2]);
        OverviewTab tab = new OverviewTab(dataModel);
        this.views[3] = new View(overviewID, null, (Component)tab);
        this.viewMap.addView(3, this.views[3]);
        LadderPanel ladderPanel = new LadderPanel(dataModel);
        this.views[4] = new View(compareClustID, null, (Component)ladderPanel);
        this.viewMap.addView(4, this.views[4]);
        this.views[5] = new View(clustDetailsID, null, (Component)new Module2ModulePanel(dataModel));
        this.viewMap.addView(5, this.views[5]);
        dataModel.setViews(this.views);
        WindowTabButtonProperties prop = this.views[0].getViewProperties().getViewTitleBarProperties().getNormalProperties().getUndockButtonProperties();
        prop.setVisible(true);
        prop.setIcon(this.BUTTON_ICON);
        prop.setToolTipText("Save figure");
        prop.setAction((DockingWindowAction)new SaveFigureAction(this.frame, dataModel, matrixPanel));
        prop = this.views[0].getViewProperties().getViewTitleBarProperties().getFocusedProperties().getUndockButtonProperties();
        prop.setVisible(true);
        prop.setIcon(this.BUTTON_ICON);
        prop.setToolTipText("Save figure");
        prop.setAction((DockingWindowAction)new SaveFigureAction(this.frame, dataModel, matrixPanel));
        prop = this.views[1].getViewProperties().getViewTitleBarProperties().getNormalProperties().getUndockButtonProperties();
        prop.setVisible(false);
        prop = this.views[1].getViewProperties().getViewTitleBarProperties().getFocusedProperties().getUndockButtonProperties();
        prop.setVisible(false);
        prop = this.views[2].getViewProperties().getViewTitleBarProperties().getNormalProperties().getUndockButtonProperties();
        prop.setVisible(true);
        prop.setIcon(this.BUTTON_ICON);
        prop.setToolTipText("Save figure");
        prop.setAction((DockingWindowAction)new SaveFigureAction(this.frame, dataModel, ppp));
        prop = this.views[3].getViewProperties().getViewTitleBarProperties().getNormalProperties().getUndockButtonProperties();
        prop.setVisible(true);
        prop.setIcon(this.BUTTON_ICON);
        prop.setToolTipText("Save figure");
        prop.setAction((DockingWindowAction)new SaveFigureAction(this.frame, dataModel, tab));
        prop = this.views[4].getViewProperties().getViewTitleBarProperties().getNormalProperties().getUndockButtonProperties();
        prop.setIcon(this.BUTTON_ICON);
        prop.setToolTipText("Save figure");
        prop.setVisible(true);
        prop.setAction((DockingWindowAction)new SaveFigureAction(this.frame, dataModel, ladderPanel));
        prop = this.views[4].getViewProperties().getViewTitleBarProperties().getFocusedProperties().getUndockButtonProperties();
        prop.setVisible(true);
        prop.setIcon(this.BUTTON_ICON);
        prop.setToolTipText("Save figure");
        prop.setAction((DockingWindowAction)new SaveFigureAction(this.frame, dataModel, ladderPanel));
        prop = this.views[5].getViewProperties().getViewTitleBarProperties().getNormalProperties().getUndockButtonProperties();
        prop.setVisible(false);
        prop = this.views[5].getViewProperties().getViewTitleBarProperties().getFocusedProperties().getUndockButtonProperties();
        prop.setVisible(false);
        MixedViewHandler handler = new MixedViewHandler((AbstractViewMap)this.viewMap, new ViewSerializer(){

            public void writeView(View view, ObjectOutputStream out) throws IOException {
                out.writeInt(((DynamicView)view).getId());
            }

            public View readView(ObjectInputStream in) throws IOException {
                return null;
            }
        });
        this.rootWindow = DockingUtil.createRootWindow((AbstractViewMap)this.viewMap, (ViewSerializer)handler, (boolean)true);
        this.properties.addSuperObject(this.currentTheme.getRootWindowProperties());
        this.rootWindow.getRootWindowProperties().addSuperObject(this.properties);
        this.rootWindow.getWindowBar(Direction.DOWN).setEnabled(true);
        this.properties.getDockingWindowProperties().setMaximizeEnabled(true);
        RootWindowProperties titleBarStyleProperties = PropertiesUtil.createTitleBarStyleRootWindowProperties();
        this.properties.addSuperObject(titleBarStyleProperties);
    }

    private void setDefaultLayout(DataModel dataModel) {
        SplitWindow splitWindow = new SplitWindow(true, 0.3f, (DockingWindow)this.views[4], (DockingWindow)this.views[5]);
        this.rootWindow.setWindow((DockingWindow)new SplitWindow(false, 0.7f, (DockingWindow)new SplitWindow(true, 0.65f, (DockingWindow)new SplitWindow(true, 0.65f, (DockingWindow)this.views[0], (DockingWindow)this.views[1]), (DockingWindow)this.views[2]), (DockingWindow)new SplitWindow(true, 0.4f, (DockingWindow)this.views[3], (DockingWindow)splitWindow)));
        WindowBar windowBar = this.rootWindow.getWindowBar(Direction.DOWN);
        while (windowBar.getChildWindowCount() > 0) {
            windowBar.getChildWindow(0).close();
        }
    }

    private void showFrame(DataModel dataModel) {
        this.frame.getContentPane().add((Component)this.rootWindow, "Center");
        this.frame.setJMenuBar(this.createMenuBar(dataModel));
        this.frame.setSize(900, 700);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setVisible(true);
    }

    private JMenuBar createMenuBar(DataModel dataModel) {
        this.menu = new CoralMenu(dataModel, this.rootWindow);
        this.frame.setJMenuBar(this.menu);
        this.rootWindow.addListener((DockingWindowListener)this.menu);
        return this.menu;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel((LookAndFeel)new InfoNodeLookAndFeel());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new JSwingCoral();
            }
        });
    }

    private static class DynamicView
    extends View {
        private static final long serialVersionUID = 1440916922477653648L;
        private int id;

        DynamicView(String title, Icon icon, Component component, int id) {
            super(title, icon, component);
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

