#!/bin/python3
# Author CF
# Date: Oct. 2024
# Goal: generate low-d points on unit hyper-sphere, 


import numpy as np
import math


def gen(n_pos: int, n_neg, m: int) -> np.array:
    """
    Generates an (n x m) matrix (n = n_pos + n_geg)
    :param n_pos: # of points in positive quadrant
    :param n_neg:  # of points in negative one
    :param m:  # dimensionality
    :return:  nxm matrix
    """
    a = np.random.rand(n_pos, m)
    b = - np.random.rand(n_neg, m)
    return np.concatenate( (a, b) )

def row_normalize_in_place(a):
    n,m = np.shape(a)
    # print( f'{n=}, {m=}')
    for row in range(n):
        sum2 = 0
        for col in range(m):
            sum2 = sum2 + a[row][col] ** 2
        sum2sqrt = math.sqrt(sum2)
        for col in range(m):
            a[row][col] = a[row][col]/sum2sqrt

def main():
    n_pos = 20 
    n_neg = 5
    m = 2
    np.random.seed(seed=0)
    a = gen(n_pos, n_neg, m)
    row_normalize_in_place(a)

    similarities = np.matmul(a, np.transpose(a))
    # original
    similarities_rounded = np.round(similarities, decimals=3)
    similarities_rounded = np.round(similarities, decimals=6)
    # print(similarities_rounded)
    # np.savetxt('similarities.csv', similarities_rounded, delimiter=',')
    n, m = np.shape(similarities_rounded)
    for row in range(n):
        for col in range(m-1):
            print(f'{similarities_rounded[row][col]},' , end="")
        print(similarities_rounded[row][m-1])

if __name__ == "__main__":
    main()
