# CF, NOv. 2024

import numpy as np
import matplotlib.pyplot as plt
import scipy.fft as sfft

def gen(N):
    ''' generates a signal with a few sinusoids and white noise'''
    # N = 1024 # number of timeticks
    t = np.array( list( range(N)) )
    # frequency, phase, amplitude triplets for the sinusoids

    parms = [ [4, np.pi/3, 1] ]

    y = np.zeros(N)
    for row in parms:
        f, ph, A = row
        y = y +  A * np.sin( 2* np.pi * f * t/N + ph)

    return t, y

def main():
    N = 1024
    # fname="sounds1024.csv"
    t,y = gen(N)

    for i in range(len(y)):
        print(f'{y[i]:5.3f}' )


if __name__ == "__main__":
    main()
