# CF, NOv. 2024

import numpy as np
import matplotlib.pyplot as plt
import scipy.fft as sfft

def gen(N):
    ''' generates a signal with a few sinusoids and white noise'''
    # N = 1024 # number of timeticks
    t = np.array( list( range(N)) )
    # frequency, phase, amplitude triplets for the sinusoids

    parms = [ [4, np.pi/4, 1],
              [6, 0,       3]]
    noise_amplitude = 10

    # set to False, to create the student's data
    # set to True, to create an example
    if False:
        parms = [ [2, 0,       2],
                  [4, np.pi/3, 1],
                  [8, 0,     1.6]]
        noise_amplitude = 3

    y = np.zeros(N)
    for row in parms:
        f, ph, A = row
        # print(f, ph, A)
        y = y +  A * np.sin( 2* np.pi * f * t/N + ph)

    np.random.seed(seed=0)
    noise = noise_amplitude * ( np.random.rand(N) - 0.5 * np.ones(N))
    # subtract the np.ones, so that the avg is zero
    y = y + noise
    return t, y

#def my_fft(s):
#    ''' does fft on the signal 's' '''
#    F = sfft.fft(s)
#    return F
#
#def denoise(s):
#    # N = s.shape()
#    F = sfft.fft(s)
#    amplitude = np.abs(F)
#    m = max(amplitude)
#    epsilon = m /10
#    for i in range(len(s)):
#        if amplitude[i] < epsilon:
#            F[i] = 0.0
#    s_clean = np.abs( sfft.ifft(F) )
#    return s_clean
#
def main():
    N = 1024
    # fname="sounds1024.csv"
    t,y = gen(N)

    for i in range(len(y)):
        print(f'{y[i]:5.3f}' )


if __name__ == "__main__":
    main()
