# CF, NOv. 2024

import numpy as np
import matplotlib.pyplot as plt
import scipy.fft as sfft
import pandas as pd
import click
import math


# def my_fft(s):
#     ''' does fft on the signal 's' '''
#     F = sfft.fft(s)
#     return F

def gen_sines(duration, specs):
    # specs should be a list of triplets [A, freq, phase ]
    # returns a signal of 'duration', with the specified sine waves
    #     as the homework4 describes them
    s = np.zeros(duration) # array of right length, all zeros
    for t in range(duration):
        for amp, freq, phase in specs:
            s[t] = s[t] + amp * math.sin( 2* math.pi * freq * t / duration + phase)
    return(s)


def denoise(s):
    # N = s.shape()
    F = sfft.fft(s)
    amplitude = np.abs(F)

    # zap frequencies with small amplitudes
    m = max(amplitude)
    epsilon = m /5 # ignore Amplitudes below that
    for i in range(len(s)):
        if amplitude[i] < epsilon:
            F[i] = complex (0.0 , 0.0)
    s_clean =  sfft.ifft(F).real # get the real parts to avoid complaints from matplotlib
    return s_clean

def get_dominant_frequencies(s):
    F = sfft.fft(s)
    amplitude = np.abs(F)

    # zap frequencies with small amplitudes
    m = max(amplitude)
    epsilon = m /5
    n_digits = 4 # digits for rounding
    result = []
    for i in range(len(s)):
        if amplitude[i]> epsilon:
            result.append( [i,  round(F[i].real, 4), round(F[i].imag,4) ])
    return result

@click.command()
@click.argument('fname', type=click.Path(exists=True, readable=True), nargs=1)
def main(fname):
    df = pd.read_csv(fname, header=None)
    verbose = True
    # there must be a better way to turn it into 'y', a 1-d array
    z = df.to_numpy()
    y = np.transpose(z)[0]    # sigh!
    duration = len(y) # duration
    t = list(range( duration) ) # create the time-ticks

    # plot the given signal
    if verbose:
        print("HW4     (not required) - plot of the given signal")
        plt.plot(t, y, 'k-', linewidth=0.5)
        plt.xlabel('time')
        plt.ylabel('value')
        plt.title('noisy signal')
        plt.savefig("noisy_signal.png")
        plt.show()



    F = sfft.fft(y)
    amplitude = np.abs(F)
    print('HW4 Q4a - plotting the amplitude spectrum')
    plt.plot(amplitude , 'ro')
    plt.title('HW4 - Q4a - Ampl. spectrum')
    plt.xlabel('freq')
    plt.ylabel('ampl')
    plt.savefig("hw4_q4a_Fourier_spectrum.png")
    plt.show()

    dominant_frequency_list = get_dominant_frequencies(y)
    # print(f'{dominant_frequency_list=}')
    num_dominant_frequencies = int( len(dominant_frequency_list)/2) #to exclude the mirrors

    print(f'HW4 Q4b : # of dominant frequencies is {num_dominant_frequencies} (and their mirrors)')

    print('HW4 Q4c - param. of generating sinusoids')
    specs = []  # freq
    for freq, Xreal, Ximag in dominant_frequency_list:
        if freq < (duration / 2.0):  # ignore the mirror part of the spectrum
            Amplitude = math.sqrt(Xreal ** 2 + Ximag ** 2) * 2 / duration
            phase = math.atan(Ximag / Xreal)
            # print(f'f{freq=}, {Amplitude=}, {phase=}')
            adjusted_phase = phase + math.pi / 2
            print(f'\t{freq=}, {Amplitude=:5.3f}, {math.degrees(adjusted_phase)=:5.3f}')
            print(f'\t\t from scipy.fft: {freq=}, {Xreal=:5.3f}, {Ximag=:5.3f}')
            specs.append([Amplitude, freq, adjusted_phase])
    answer_signal = gen_sines(duration, specs) # generate the signal according the specs

    y_clean = denoise(y)
    print('HW4 Q4d - plotting the denoised signal')
    plt.plot(t, y, 'k.', markersize=1, label='noisy' )
    plt.plot(t, y_clean, 'b-' , markersize=5, linewidth=5, label='inverse fft')
    plt.plot(t, answer_signal, 'r.', markersize=1, label='reconstructed')
    plt.legend(loc='upper right')
    plt.xlabel('time')
    plt.ylabel('value')
    plt.title('HW4 - Q4d - denoised')
    plt.savefig("hw4_q4d_denoised_signal.png")
    plt.show()



if __name__ == "__main__":
    main()
