: # Use perl
   eval 'exec perl5 -w -S $0 "$@"'
   if 0;

# it is faster to use something like
#!/usr/local/bin/perl5 
# but this is more portable.

#
# $Log:	sampleNpcp.pl,v $
# Revision 7.1  99/08/11  01:27:06  christos
# ready to go
# 
# Revision 6.10  99/08/11  00:55:38  christos
# added setdefaults
# 
# Revision 6.1  99/08/10  19:22:50  christos
# fitting without chopping
# 
# Revision 5.1  99/08/10  02:33:55  christos
# ready to go
# 
# Revision 4.5  99/08/10  02:31:04  christos
# added sampleNpcp.pl;
# also, titles on the graphs
# 
# Revision 1.1  99/08/10  01:15:05  christos
# Initial revision
# 

# expects two files
# samples them,
# and makes the pair-count-plot of the samples
# along with the postscript file and the fitting lines


use strict;

my $verbose = 0;
my $debug = 0;
my $dmin = 0.01;
my $factor = 1.1;


require "setdefaults.pl";
my $rmax; # not really needed
($dmin, $rmax, $factor) = setdefaults();


my $nargs;
my @fname=();
my $inp1;
my $inp2;
my $myfloor = 0; #use POSIX's floor(), unless $myfloor is set
my $ptname;
my $s = 10; # sampling factor: 1-out-of$s is chosen
my $scslist="$s" ;  # list of comma separated 's' values

while( $_ = $ARGV[0], /^-/){
   shift;
   last if /^--$/;
   if( /^-D(.*)/){ $debug = $1 }
   if( /^-d(.*)/){ $dmin = $1 }
   if( /^-f(.*)/){ $factor = $1 }
   if( /^-s(.*)/){ $scslist = $1 }
   if (/^-v/)    { $verbose++ }
}

# print " ***** scslist= ", $scslist , "\n";
$nargs = $#ARGV + 1;   # the number of remaining arguments

if( $nargs != 2 ) { 
   die "USAGE: $0 [-v] [-d<dmin>]" .
       " [-f<factor>] " .
       " [-s<sampling-factor,s2,s3,...>]" .
       " <datafile1> <df2>";  }

$fname[0] = $ARGV[0];
$fname[1] = $ARGV[1];
$inp1 = $fname[0];
$inp2 = $fname[1];

if( $verbose > 1){
    print "*** verbose=", $verbose, "\n";
    print "*** factor=", $factor, "\n";
    print "*** dmin=", $dmin, "\n";
    print "*** datafname1=|", $fname[0], "| ", "datafname2=|", $fname[1], "|\n";
}


my $pcpfname = "${inp1}-${inp2}.sNpcp"; # shorthand for pair-count plot
my $allnames = "";

my @slist;
# print "scslist= ", $scslist, "\n";
@slist = split( ",", $scslist );

# print join( "-", @slist), "\n";

for $s ( @slist ) {
    if( $verbose > 0 ){ print " sampleNpcp.pl working for s=", $s, "\n"; }

    my $inp1s = "${inp1}-s${s}" ;
    my $inp2s = "${inp2}-s${s}" ;

    `perl5 sample.pl -k$s $inp1 > ${inp1}-s${s} `;
    `perl5 sample.pl -k$s $inp2 > ${inp2}-s${s} `;

    my $spcpfname = "${inp1s}-${inp2s}.pcp"; # shorthand for pair-count plot

    # make the log-log pair-count plot
    `perl5 npairs.pl $inp1s $inp2s |\
    perl5 lbucketize.pl -d${dmin} -f${factor} |\
    perl5 dezero.pl |\
    perl5 loglog.pl > ${spcpfname} `;

    print "***  killing the flat parts ...\n" if ($verbose);
    `perl5 killFlats.pl ${spcpfname} > ${spcpfname}-nf `;

    $allnames .= "${spcpfname} ";



    if ($verbose){
	print "plain fit:";
	print `cat ${spcpfname}-nf | perl5 calcslope.pl `;
	print "robust fit:";
	print `cat ${spcpfname}-nf | perl5 fit.pl `;
    }

} # end for

    # put everything into a eps plot
    `newmygnuplot -l "PCP plot w/ sampling" -slope -o ${pcpfname}.eps -xlabel "log(dist)" -ylabel "log(count-of-pairs)" -s points ${allnames} ` ;

if( $verbose > 0 ) {
    `ghostview ${pcpfname}.eps`
}

