: # Use perl
   eval 'exec perl5 -w -S $0 "$@"'
   if 0;

require "util.pl"; 
require "assert.pl";

use strict;

# it is faster to use something like
#!/usr/local/bin/perl5 
# but this is more portable.

#
# $Log:	mkCorrInt.pl,v $
# Revision 7.1  99/08/11  01:27:06  christos
# ready to go
# 
# Revision 6.10  99/08/11  00:55:38  christos
# added setdefaults
# 
# Revision 6.1  99/08/10  19:22:50  christos
# fitting without chopping
# 
# Revision 5.1  99/08/10  02:33:55  christos
# ready to go
# 
# Revision 4.5  99/08/10  02:31:04  christos
# added sampleNpcp.pl;
# also, titles on the graphs
# 
# Revision 4.4  99/08/10  00:19:39  christos
# added cdeNpcp - ready to go
# 
# Revision 4.3  99/08/10  00:10:38  christos
# *** empty log message ***
# 
# Revision 4.1  99/08/09  23:13:00  christos
# integrated schuster and pair-count plots
# 
# Revision 1.1  99/08/09  22:40:46  christos
# Initial revision
# 
# Revision 3.1  99/08/09  19:32:37  christos
# ready to go
# 
# Revision 1.2  99/08/09  19:25:48  christos
# ready to go, with robust regression
# 
# Revision 1.1  99/08/09  16:57:13  christos
# Initial revision
# 
# Revision 3.3  1999/08/09 05:33:38  christos
# added warnings for 'floor' function
#
# Revision 3.2  1999/08/09 05:08:47  christos
# fixed the reference passing of filehandles INP1 INP2
#
# Revision 3.1  1999/08/08 07:08:02  christos
# has single function for making the cells;
#
# Revision 1.3  1999/08/07 13:17:40  christos
# *** empty log message ***
#
# Revision 1.2  1999/08/07 11:40:27  christos
# does not need POSIX
#
#
# expects TWO input file, with new-line separated records
# computes the cross correlation integral 
#    CCI(r) =  sum_i  count(A,i) * count(B,i)
# over all the cells $i$=1...
# for a given cell size (r).
# It prints pairs of values:
#      r     CCI(r)
#

use POSIX;
# we need it for the 'floor' function - but can live without it,
# thanks to:
require "util.pl";
# if POSIX is unavailable, feel free to comment it out

my $verbose = 0;
my $debug = 0;
# $q = 0;
my $rmin = 0.0000001;
my $rmax = 1000000;
my $factor = 1.3;

while( $_ = $ARGV[0], /^-/){
   shift;
   last if /^--$/;
   if( /^-D(.*)/){ $debug = $1 }
   if( /^-r(.*)/){ $rmin = $1 }
   if( /^-R(.*)/){ $rmax = $1 }
   if( /^-f(.*)/){ $factor = $1 }
   # if( /^-q(.*)/){ $q = $1 }
   if (/^-v/)    { $verbose++ }
}

my $nargs = $#ARGV + 1;   # the number of remaining arguments

if( $nargs != 2 ) { 
   die "USAGE: $0 [-v] [-r<rmin>]" .
       " [-f<factor>] " .
       " [-R<rmax>] <datafile1> <datafile2>";  }

my @fname=();
$fname[0] = $ARGV[0];
$fname[1] = $ARGV[1];

if( $verbose > 0){
    print "*** verbose=", $verbose, "\n";
    print "*** factor=", $factor, "\n";
    print "*** rmin=", $rmin, " rmax=", $rmax, "\n";
    print "*** datafname1=|", $fname[0], "| ", "datafname2=|", $fname[1], "|\n";
}



# scan the input file,
# compute the 'floor' of each entry
# update the appropriate count in a hash table

# $globallen = 0;

open (INP1, $fname[0])  or die "can not open $fname[0]\n";
open (INP2, $fname[1]) or die "can not open $fname[1]\n";

my $hasWarnedFloor;

my $r;
for( $r = $rmin; $r <= $rmax; $r *= $factor ){


   my %hcount1=();
   # collect counts for the first file
   hfill(\*INP1, \%hcount1, $r);
   # warn("    hfill should be called with \*INP1\n");


   my %hcount2=(); # clear the hash table with the counts per cell
   # collect counts for the first file
   hfill(\*INP2, \%hcount2, $r);
   # warn("    hfill should be called with \*INP2\n");

   # print "OK\n";


   # collect the statistics:
   my $total =0;
   my $key;

   # hprint(\%hcount1);
   # hprint(\%hcount2);

   foreach $key ( keys %hcount1 ) {
       my $res1 = 0;
       my $res2 = 0;

       if( defined( $hcount1{$key} ) ) { $res1 = $hcount1{$key}; }
       if( defined( $hcount2{$key} ) ) { $res2 = $hcount2{$key}; }

       # $total += $hcount1{$key} * $hcount2{$key};
       $total += ($res1 * $res2);
   }
   print $r, " ", $total, "\n" unless ( $total == 0  ) ;
   seek INP1, 0, 0; # rewind
   seek INP2, 0, 0; # rewind


} # end for $r



# require "util.pl"; # for the 'assert' function
require "assert.pl";

# fills in the counts
# It expects 
#     INP: an open file handle
#     href: a reference to a hash table that will collect the counts
#     r   : a scalar (the grid-cell size

sub hfill {
   my $finp;
   # local $finp; # for reasons that I don't understand...
   my $href;
   my $r;
   my $arglen;

   $arglen = scalar ( @_ );

   assert ( $arglen == 3, "*** wrong arg count in 'hfill': $arglen vs 3" );

   ($finp, $href, $r) = @_ ;

   # collect counts for the first file
   # %$href=(); # clear the hash table with the counts per cell

   my $lineno = 0;
   my @words;
   my $len;
   my $globallen =0;

   seek $finp, 0, 0; # make sure we are at the begining
   while(<$finp>){
       $lineno ++;

       s/^\s+//; # kill leading white space
       s/\s+$//; # kill trailing  white space
       # if( $verbose > 2) { print "INPUT: ", $_, "\n"; }

       @words = split;
       $len = scalar (@words);

       # check for bad input, with improper dimensionality
       if( $lineno == 1){ $globallen = $len; }
       else {
	  if ($len != $globallen ) {
	      die "line ", $lineno, " has ", 
		   $len, "entries instead of ", 
		  $globallen, "\n";
	  }
       }


       my @floorwords = ();
       if ( defined( &floor ) ){
            @floorwords = map { floor($_ /$r )  } @words;
       } else {
            @floorwords = map { myfloor($_ /$r )  } @words;
	    if( $hasWarnedFloor != 1 ){
	        warn "    using home-made floor function...\n";
		$hasWarnedFloor = 1;
           }
       }
       # @floorwords = map { myround($_ /$r )  } @words;
       # replaced 'floor' with 'round' - 8/7/99
       my $out = join ':', @floorwords;
       if($verbose > 4 ) { print $out, "\n"; }
       $$href{$out} ++;

   } # while $finp

} # end hfill
