# expects two arrays $x and $y
# and returns the coefficients of Least TRIMMED Squares regression
# Ie, it minimizes the sum of least squares for the $q$
# points with the smallest deviations.
# (see , eg., Modern Applied Statistics with S-Plus
#     	Venables and Ripley, Springer, pp 316
#	2nd edition
# $q$ is len/2 + 1 ;
# Slight modification: the chosen points are consecutive,
# as opposed to randomly chosen
# Specifically:
#	x,y	are the arrays of the x and y values
# it returns
#	a,b,r	slope, intercept and corr. coeff
#	start, end	the starting and ending offset
#			for the matching portion;

#
# $Log:	lts.pl,v $
# Revision 7.1  99/08/11  01:27:06  christos
# ready to go
# 
# Revision 6.10  99/08/11  00:55:38  christos
# added setdefaults
# 
# Revision 6.1  99/08/10  19:22:50  christos
# fitting without chopping
# 
# Revision 5.1  99/08/10  02:33:55  christos
# ready to go
# 
# Revision 4.5  99/08/10  02:31:04  christos
# added sampleNpcp.pl;
# also, titles on the graphs
# 
# Revision 4.4  99/08/10  00:19:39  christos
# added cdeNpcp - ready to go
# 
# Revision 4.3  99/08/10  00:10:38  christos
# *** empty log message ***
# 
# Revision 4.1  99/08/09  23:13:00  christos
# integrated schuster and pair-count plots
# 
# Revision 1.1  99/08/09  22:40:46  christos
# Initial revision
# 
# Revision 3.1  99/08/09  19:32:37  christos
# ready to go
# 
# Revision 1.1  99/08/09  16:57:13  christos
# Initial revision
# 
# Revision 1.1  1999/08/09 08:18:16  christos
# Initial revision
#
# Revision 1.3  1999/08/09 07:09:01  christos
# *** empty log message ***
#
# Revision 1.2  1999/08/09 04:35:32  christos
# passing of array refs as parms works OK -
#
# Revision 1.1  1999/08/09 03:12:57  christos
# Initial revision
#
#
#

require "lsfit.pl";
require "assert.pl";

use strict;

sub lts(\@\@){
    my ($xaref,  $yaref);
    my ($n, $i);
    my $arglen;
    my $xlen;
    my $ylen;
    my (@smallx, @smally);
    my ($a, $b, $r);   # intercept, slope and corr. coeff.
    my ($start, $end); # offsets of matching portion
    my $q;	# stretch to match = end-start +1

    my $diff;
    my $currentDiff ;
    my $currentStart ;
    my ( $currenta , $currentb , $currentr);

    # parse the parms
    $arglen = scalar(@_);
    assert( $arglen ==2, "lts: wrong count of args (" . $arglen . ")" );

    ($xaref, $yaref) = ( @_ );
    assert( (ref($xaref) eq 'ARRAY' ) && ( ref($yaref) eq 'ARRAY' ) , 
       "lts: usage lts( array, array )" );

    $xlen = scalar( @$xaref);
    $ylen = scalar( @$yaref);

    assert( $xlen == $ylen, "lts: arrays of diff sizes $xlen $ylen" );
    $n = $xlen;
    $q = int ( $n/2) +1; #according to Venable + Ripley

    for( $start =0; $start < $n - $q + 1 ; $start ++ ){
        $end = $start + $q -1;
	if( $main::verbose > 2 ){
	    print "start: $start , end: $end , n = $n , q = $q \n";
	}

	# also works
	# @smallx = @{ $xaref} [ $start .. $end ];
	# @smally = @{ $yaref} [ $start .. $end ];

	my $i;
	for($i=0; $i<$q; $i++){
	   $smallx[$i] = $$xaref[$i+$start];
	   $smally[$i] = $$yaref[$i+$start];
	}

	if( $main::verbose > 2 ){
	   print "lts: ", join("|", @smallx) . "\n" ;
	   print "lts: ", join("|", @smally) . "\n" ;
	}

	($a, $b, $r) = lsfit ( @smallx , @smally );
	# surprisingly, \@smallx etc DOES NOT WORK!
	# $a=$b=$r= 9999999; #TST


	if( $main::verbose > 2){
	   print "    a= $a b= $b r= $r \n";
        }

	$diff = sumsqdiff( @smallx, @smally, $a, $b);
	if( !defined($currentDiff) || ($diff < $currentDiff ) ) {
	    # new champion, with smaller diffs
	    $currentDiff = $diff;
	    $currentStart = $start;
	    $currenta = $a;
	    $currentb = $b;
	    $currentr = $r;
	}

    }# end for

    return( $currenta, 
            $currentb,
            $currentr, 
            $currentStart, 
            ( $currentStart + 
              $q - 1) );


}# end lts




return(1); # for 'require'
