: # Use perl
   eval 'exec perl5 -w -S $0 "$@"'
   if 0;

# it is faster to use something like
#!/usr/local/bin/perl5 
# but this is more portable.

#
# $Log:	lbucketize.pl,v $
# Revision 7.1  99/08/11  01:27:06  christos
# ready to go
# 
# Revision 6.10  99/08/11  00:55:38  christos
# added setdefaults
# 
# Revision 6.1  99/08/10  19:22:50  christos
# fitting without chopping
# 
# Revision 5.1  99/08/10  02:33:55  christos
# ready to go
# 
# Revision 4.5  99/08/10  02:31:04  christos
# added sampleNpcp.pl;
# also, titles on the graphs
# 
# Revision 4.4  99/08/10  00:19:39  christos
# added cdeNpcp - ready to go
# 
# Revision 4.3  99/08/10  00:10:38  christos
# *** empty log message ***
# 
# Revision 4.1  99/08/09  23:13:00  christos
# integrated schuster and pair-count plots
# 
# Revision 1.1  99/08/09  22:40:46  christos
# Initial revision
# 
# Revision 1.3  99/08/09  22:07:08  christos
# *** empty log message ***
# 
# Revision 1.2  99/08/09  21:47:51  christos
# fixed off-by-1 error
# 
# Revision 1.1  99/08/09  21:38:15  christos
# Initial revision
# 

# expects a file with distances (one per line, like 'npairs.pl' does)
# and prints their counts in logarithmic buckets
# of distance $df
# That is, the result is the pair-count plot:
# number of pairs within distance $d or less, vs $d
# in LINEAR SCALES

use strict;

my $verbose = 0;
my $debug = 0;
my $dmin = 0.0001;
my $df = 1.1;



require "setdefaults.pl";
my $rmax; # actually, never used
($dmin, $rmax, $df) = setdefaults();


my $nargs=0;
my $fname;
my $myfloor = 0; #use POSIX's floor(), unless $myfloor is set

use POSIX;

while( $_ = $ARGV[0], /^-/){
   shift;
   last if /^--$/;
   if( /^-D(.*)/){ $debug = $1 }
   if( /^-d(.*)/){ $dmin = $1 }
   if( /^-f(.*)/){ $df = $1 }
   if( /^-m/){ $myfloor = 1 }
   if (/^-v/)    { $verbose++ }
}

# print "ARGV count: ", $#ARGV , "\n";
$nargs = $#ARGV + 1;   # the number of remaining arguments
# $nargs = scalar(@ARGV) + 1;   # the number of remaining arguments
# print "nargs=", $nargs, "\n";

if( $nargs > 1 ) { 
   die "USAGE: $0 [-v] [-d<dmin>]" .
       " [-f<dist-factor>] " .
       " <datafile> ";  }

# if($nargs == 1){
 #   $fname = $ARGV[0];
# } else {
   # $fname = "STDIN";
# }

if( $verbose > 1){
    print "*** verbose=", $verbose, "\n";
    print "*** factor=", $df, "\n";
    print "*** dmin=", $dmin, "\n";
    if($nargs == 1) {print "*** datafname=|", $fname, "|\n"; }
}


my $dist;
my $tinycount=0;   # count of distances less than dmin
my %h = ();        # histogram with counts
my $bid;	   # bucket id

while(<>){
   ($dist ) = $_ ;
   # print $dist, "\n";
   if( $dist <= $dmin ) { $tinycount ++ ; }
   else {    # have to determine bucket-id
       $bid = floor( log($dist/$dmin) / log($df) );


       if( !defined ($h{$bid}) ) { $h{$bid} = 1; }
       else { $h{$bid} ++; }

       if( $verbose > 2 ) {
	   print "h(", $bid , ")=", $h{$bid},  " dist: " , $dist,  "\n";
       }
   }
} # end while

$dist = $dmin;
if( $tinycount > 0 ) { print "$dist $tinycount\n" ;}
my $count = $tinycount;

if( $verbose > 1){
   print "printing out the histogram, in hash order:\n";
   for $bid ( keys %h ){
       print $bid, " ", $h{$bid}, "\n";
   }
   print "\n\n";
}

for $bid ( sort  { $a <=> $b }   keys %h ) {
   $count += $h{$bid};
   $dist = $dmin * $df * $df ** $bid ;
   # print "dist: $dist      count: $count\n";
   print "$dist $count\n";
}

