#!/usr/bin/perl -w 

#: # Use perl
#   eval 'exec perl5 -w -S $0 "$@"'
#   if 0;

# it is faster to use something like
#!/usr/local/bin/perl5 
# but this is more portable.

#!/perl/bin/perl5 -w

require "lsfit.pl";
require "lts.pl";

use strict;

my @x = ();
my @y = ();
my ($a, $b, $r, $start, $end);
my ($diff);

$main::verbose = 0;

my $i =0;
my ($Fld1, $Fld2);
while (<>) {
    my @words = split;
    assert( scalar(@words) == 2,
         "*** usage: fit.pl (file-with-x-and-y-per-line)");
    ($Fld1,$Fld2) = split(' ', $_, 9999);
    $x[$i] = $Fld1;
    $y[$i] = $Fld2;
    $i ++;
}

if( $main::verbose >2){
    print "main::x= ", join(":", @x), "\n";
    print "main::y= ", join(":", @y), "\n";
    ($a, $b, $r) = lsfit (\@x, \@y);
    # ($a, $b, $r) = lsfit (@x, @y); # for some reason, it does not work
    # although the lsfit prototype clearly has \@\@

    printf "slope=%.2f", $a;
    printf " y-intercept=%.2f", $b ;
    printf " corr.=%.2f\n", $r ;
    
    $diff = sumsqdiff( \@x, \@y, $a, $b);
    printf "     sum of sq. diff=%.2f\n", $diff ;
}

# print "fit.pl: ";
($a, $b, $r, $start, $end) = lts( \@x, \@y);
# print join( " ", ($a, $b, $r, $start, $end)  ) . " \n";

if( $main::verbose >1){
    print " BEST FIT with Least Trimmed Squares \n";
    printf "\tslope=%.2f", $a;
    printf "\ty-intercept=%.2f", $b ;
    printf "\t corr.=%.2f\n", $r ;
    # print "\t start=", $start, " end=", $end , "\n";
    print "\t x-start=", $x[$start], " x-end=", $x[$end] , "\n";

    print "interpolating line: \n\n";
    print $x[$start], " ", $a*$x[$start] + $b, "\n";
    print $x[$end], " ", $a*$x[$end] + $b, "\n";
}

    $a = sprintf "%.3f", $a;
    $b = sprintf "%.2f", $b;
    $r = sprintf "%.4f", $r;
    my $xstart = sprintf "%.4f", $x[$start];
    my $xend = sprintf "%.4f", $x[$end];
    print "slope= ", $a, "	y_intcpt= ", $b, "	corr= ", $r;
    print "	x-start= ", $xstart, "	x-end= ", $xend, "\n";


