: # Use perl
   eval 'exec perl5 -w -S $0 "$@"'
   if 0;

# it is faster to use something like
#!/usr/local/bin/perl5 
# but this is more portable.

#
# $Log:	cdeNpcp.pl,v $
# Revision 7.1  99/08/11  01:27:06  christos
# ready to go
# 
# Revision 6.10  99/08/11  00:55:38  christos
# added setdefaults
# 
# Revision 6.1  99/08/10  19:22:50  christos
# fitting without chopping
# 
# Revision 5.1  99/08/10  02:33:55  christos
# ready to go
# 
# Revision 4.5  99/08/10  02:31:04  christos
# added sampleNpcp.pl;
# also, titles on the graphs
# 
# Revision 4.4  99/08/10  00:19:39  christos
# added cdeNpcp - ready to go
# 
#
# expects TWO input file, with new-line separated records
# computes the schuster/CDE-plot AND the PCP-plot
# and stores both in an *.eps file

use strict;

my $verbose = 0;
my $debug = 0;
# $q = 0;
my $rmin = 0.01;
my $rmax = 5000;
# my $factor = 2;
my $factor = 1.1;


require "setdefaults.pl";
($rmin, $rmax, $factor) = setdefaults();

my $dmin = $rmin;

my $nargs;
my @fname=();
my $inp1;
my $inp2;
my $myfloor = 0; #use POSIX's floor(), unless $myfloor is set
my $ptname;

while( $_ = $ARGV[0], /^-/){
   shift;
   last if /^--$/;
   if( /^-D(.*)/){ $debug = $1 }
   if( /^-r(.*)/){ $rmin = $1 }
   if( /^-R(.*)/){ $rmax = $1 }
   if( /^-d(.*)/){ $dmin = $1 }
   if( /^-f(.*)/){ $factor = $1 }
   # if( /^-q(.*)/){ $q = $1 }
   if (/^-v/)    { $verbose++ }
}

$nargs = $#ARGV + 1;   # the number of remaining arguments

if( $nargs != 2 ) { 
   die "USAGE: $0 [-v] [-r<rmin>]" .
       " [-f<factor>] " .
       " [-m] " .
       " [-R<rmax>] <datafile1> <df2>";  }

$fname[0] = $ARGV[0];
$fname[1] = $ARGV[1];
$inp1 = $fname[0];
$inp2 = $fname[1];

if( $verbose > 1){
    print "*** verbose=", $verbose, "\n";
    print "*** factor=", $factor, "\n";
    print "*** rmin=", $rmin, " rmax=", $rmax, "\n";
    print "*** datafname1=|", $fname[0], "| ", "datafname2=|", $fname[1], "|\n";
}

my $basefname = "${inp1}-${inp2}"; 
$ptname = "${basefname}.cde-ll"; # shorthand for file with points ('cde')

`perl5 mkCorrInt.pl  -r${rmin} -R${rmax}  -f${factor} $inp1 $inp2 |\
    perl5 dezero.pl  |\
    perl5 loglog.pl > ${ptname} `;

    # perl5 killFlats.pl > ${ptname} `;

my $pcpname = "${inp1}-${inp2}.pcp-ll"; # shorthand for file with points

`perl5 npairs.pl $inp1 $inp2 |\
    perl5 lbucketize.pl -d${dmin} -f${factor} |\
    perl5 dezero.pl |\
    perl5 loglog.pl > ${pcpname} `;
    # perl5 killFlats.pl  



`newmygnuplot -l "CDE + PCP plot" -slope -s points -xlabel "log(side)" -ylabel "log(sum-products)" -o ${basefname}-cdeNpcp.eps ${ptname}  ${pcpname}` ;

if( $verbose > 0 ) {
   # `xgraph -lnx -lny ${inp1}-${inp2}.points`;
   `ghostview  ${basefname}-cdeNpcp.eps `;

}


