: # Use perl
   eval 'exec perl -w -S $0 "$@"'
   if 0;

# it is faster to use something like
#!/usr/local/bin/perl5 
# but this is more portable.

#
# $Log:	cde.pl,v $
# Revision 7.1  99/08/11  01:27:06  christos
# ready to go
# 
# Revision 6.10  99/08/11  00:55:38  christos
# added setdefaults
# 
# Revision 6.2  99/08/10  19:22:50  christos
# fitting without chopping
# 
# Revision 6.1  99/08/10  19:21:35  christos
# *** empty log message ***
# 
# Revision 5.1  99/08/10  02:33:55  christos
# ready to go
# 
# Revision 4.5  99/08/10  02:31:04  christos
# added sampleNpcp.pl;
# also, titles on the graphs
# 
# Revision 4.4  99/08/10  00:19:39  christos
# added cdeNpcp - ready to go
# 
# Revision 4.3  99/08/10  00:10:38  christos
# *** empty log message ***
# 
# Revision 4.1  99/08/09  23:13:00  christos
# integrated schuster and pair-count plots
# 
# Revision 1.1  99/08/09  22:40:46  christos
# Initial revision
# 
# Revision 3.1  99/08/09  19:32:37  christos
# ready to go
# 
# Revision 1.2  99/08/09  19:25:48  christos
# ready to go, with robust regression
# 
# Revision 1.1  99/08/09  16:57:13  christos
# Initial revision
# 
# Revision 1.2  1999/08/09 05:08:47  christos
# *** empty log message ***
#
# Revision 1.1  1999/08/07 11:25:55  christos
# Initial revision
#
# Revision 1.2  99/08/05  04:54:40  christos
# *** empty log message ***
# 
# Revision 1.1  99/08/04  23:59:22  christos
# Initial revision
# 
#
# expects TWO input file, with new-line separated records
# computes the CDE-plot
# chops the flat parts
# and fits a line
# storing everything in an *.eps file

use strict;

my $verbose = 0;
my $debug = 0;
# $q = 0;
my $rmin = 0.01;
my $rmax = 5000;
# my $factor = 2;
my $factor = 1.1;


require "setdefaults.pl";
($rmin, $rmax, $factor) = setdefaults();

my $nargs;
my @fname=();
my $inp1;
my $inp2;
my $myfloor = 0; #use POSIX's floor(), unless $myfloor is set
my $ptname;

while( $_ = $ARGV[0], /^-/){
   shift;
   last if /^--$/;
   if( /^-D(.*)/){ $debug = $1 }
   if( /^-r(.*)/){ $rmin = $1 }
   if( /^-R(.*)/){ $rmax = $1 }
   if( /^-f(.*)/){ $factor = $1 }
   if( /^-m/){ $myfloor = 1 }
   # if( /^-q(.*)/){ $q = $1 }
   if (/^-v/)    { $verbose++ }
}

$nargs = $#ARGV + 1;   # the number of remaining arguments

if( $nargs != 2 ) { 
   die "USAGE: $0 [-v] [-r<rmin>]" .
       " [-f<factor>] " .
       " [-m] " .
       " [-R<rmax>] <datafile1> <df2>";  }

$fname[0] = $ARGV[0];
$fname[1] = $ARGV[1];
$inp1 = $fname[0];
$inp2 = $fname[1];

if( $verbose > 1){
    print "*** verbose=", $verbose, "\n";
    print "*** factor=", $factor, "\n";
    print "*** rmin=", $rmin, " rmax=", $rmax, "\n";
    print "*** datafname1=|", $fname[0], "| ", "datafname2=|", $fname[1], "|\n";
}

$ptname = "${inp1}-${inp2}.points"; # shorthand for file with points

`perl5 mkCorrInt.pl  -r${rmin} -R${rmax}  -f${factor} $inp1 $inp2 > ${ptname}`;
`perl5 dezero.pl ${ptname} | perl5 loglog.pl > ${ptname}-ll`;
` perl5 killFlats.pl ${ptname}-ll > ${ptname}-llnf `;

`newmygnuplot -slope -l "CDE plot: $inp1 - $inp2" -s points -xlabel "log(side)" -ylabel "log(sum-products)" -o ${ptname}-ll.eps ${ptname}-ll  ` ;

if( $verbose > 0 ) {
   # `xgraph -lnx -lny ${inp1}-${inp2}.points`;
   `ghostview  ${ptname}-ll.eps `;

print "plain fit: ";
print `cat ${ptname} | perl5 dezero.pl |\
    perl5 loglog.pl |  perl5 killFlats.pl | perl5 calcslope.pl `;

print "robust fit: ";
print `cat ${ptname} | perl5 dezero.pl |\
    perl5 loglog.pl |  perl5 killFlats.pl | perl5 fit.pl `;

}

