#!/bin/bash

# Author: Christos Faloutsos
# Date: Feb. 2015
# Goal: accepts a file of triplets (x,y,count)
#       bucketizes it logarithmically
#       and plots it

pname=$0
usage=" USAGE: $pname [-b base ] filename "
b=2.0 # default

while getopts "b:h" flag
do
    case "$flag" in
        b) b=$OPTARG;;
	h) echo $usage
	   exit;;
	?) echo "Flag $flag unknown - ignored"
	   echo $usage ;;
    esac
done

shift $(($OPTIND - 1))

if [ $# -ne 1 ]; then
    echo "ERROR: give a filename"
    echo $usage
    exit 1
fi

fname=$1

if [ -x "$b" ]; then
    b=2.0 #default
fi

echo "    FYI: $pname working on '$fname' with b= $b "
temp_file=${1%.txt}_b${b}.tmp
out_file_name=${1}_b${b}_heatmap.pdf

python bucketize.py -b $b $1 > $temp_file
gnuplot -e "filename='${temp_file}'; outfile='${out_file_name}'" heatmap0.plt
open $out_file_name

\rm -f $temp_file
