#!/opt/local/bin/python
#!/bin/python

########################################################
# AUTHOR: Christos Faloutsos
# DATE:   Feb. 2015
########################################################
# GOAL: create heatmaps, with log-bucketized
#       axes. That is, it expects triplets like
#           x, y, count
#       all positive integers
#       and it rounds down x and y, to power of 2
########################################################

import csv
import math as M
import sys
import getopt
import log_floor as L

verbose=0

base=2.0
# base=M.sqrt(2.0)

# base=1.4
# log_base = M.log(base)

def usage():
    print "USAGE: ", sys.argv[0], "  [-h] [-b base] filename.csv"
    print "          [-h --help]:    help: this very message"
    print "          [-b --base]:    base of logarithms (default: 2.0) "

def shiftargs():
    sys.argv[1:] = sys.argv[2:]

try:
    opts, args = getopt.getopt(sys.argv[1:], "hb:", ["help", "base"])
except getopt.GetoptError:
    usage()
    sys.exit(2)

for o, a in opts:
    if o in ("-b", "--base"):
        base = float(a)
        # base = float(2.0) # other values, need debugging
        assert base > 1.0
        shiftargs()
        shiftargs()
    if o in ("-h", "--help"):
        usage()
        sys.exit()

if( len(sys.argv) != 2):
    print "n arguments = ", len(sys.argv)
    print "the argument list: ", sys.argv
    usage()
    sys.exit(-2)

fname = sys.argv[1]
csvReader = csv.reader(open(fname), delimiter=',', quotechar='"')

if(verbose):
    print "FYI: argv[0] starting....."

mycount = {}

raw_total=0

for row in csvReader:
    (x,y,cnt) = row
    if(verbose):
        print "\nx= ", x, "\ty= ", y, "\tcnt= ", cnt
    raw_total += int(cnt)
    bx = L.log_floor(x,base)
    by = L.log_floor(y,base)
    if(verbose):
        print "%s,%s,%s" % (bx ,  by,  cnt)
    if bx in mycount:
        if by in mycount[bx]:
            mycount[bx][by] += int(cnt)
        else: # by is new
            mycount[bx][by]={}
            mycount[bx][by]= int(cnt)
    else: # bx is new
        mycount[bx]={}
        mycount[bx][by]={}
        mycount[bx][by]= int(cnt)

if(verbose):
    print "done with parsing the file - now printing "

buck_total = 0

for bx in sorted(mycount.keys()):
    for by in sorted(mycount[bx].keys()):
        # print bx, by, mycount[bx][by]
        cnt = mycount[bx][by]
        print "%d,%d,%d" % (int(bx) ,  int(by),  int(cnt))
        buck_total += int(cnt)

if (verbose):
    print "# raw_total= ", raw_total, "buck_total= ", buck_total

assert raw_total == buck_total
